// $Id: name_generator.cpp,v 1.3 2004/08/01 11:37:47 jean Exp $

#include <algorithm>
#include <set>
#include <sstream>
#include <functional>
#include <interfaces/name_generator.h>

using namespace std;

namespace
{
	struct FindById : public std::unary_function<std::pair<int, string>, bool>
	{
		int atom_;
		FindById(int atom)
			:	atom_(atom)
		{}
		inline bool operator()(const std::pair<int, string>& entry) const
		{
			return entry.first == atom_;
		}
	};

	const char* const PREFIX = "_invisible";
}

bool NameGenerator::addAtom(int atom)
{
	Atom2Name::iterator res = find_if(dictionary_.begin(), dictionary_.end(), FindById(atom));
	if(res == dictionary_.end())
	{
		dictionary_.push_back(Atom2Name::value_type(atom, string()));
		return true;
	}
	return false;
}
bool NameGenerator::setName(int atom, const std::string& name)
{
	Atom2Name::iterator res = find_if(dictionary_.begin(), dictionary_.end(), FindById(atom));
	if(res == dictionary_.end())
		return false;
	
	res->second = name;
	return true;
};
void NameGenerator::generate()
{
	// obtain atom names of atoms
	// that did have names in the logic
	// program
	set<string> names;
	for(Atom2Name::const_iterator it = dictionary_.begin();
		it != dictionary_.end();
		++it)
	 {
	 	if(!it->second.empty())
	 		names.insert(it->second);
	 }
	 
	 // generate names 
	 int counter = 0;
	 for(Atom2Name::iterator it = dictionary_.begin();
		it != dictionary_.end();
		++it)
	 {
	 	while(it->second.empty())
	 	{
	 		--counter;
	 		stringstream n;
	 		n << PREFIX << counter;
	 		if(!names.count(n.str()))
	 			it->second = n.str();
	 	}
		names.insert(it->second);
	 }
}

const std::string& NameGenerator::getName(int atom) const // throws NoName
{
	Atom2Name::const_iterator res = find_if(dictionary_.begin(), dictionary_.end(), FindById(atom));
	if(res == dictionary_.end())
		throw NoName();
	
	if(res->second.empty())
		throw NoName();
	return res->second;
}
