// $Id: name_generator.h,v 1.2 2004/08/01 11:37:47 jean Exp $

#ifndef NAME_GENERATOR_H
#define NAME_GENERATOR_H

#include <vector>
#include <utility>
#include <string>
#include <stdexcept>

struct NoName : public std::runtime_error
{
	NoName(const std::string& reason = "Forgot to generate names?")
		:	std::runtime_error(reason)
	{}
};

class NameGenerator
{
	typedef std::vector< std::pair<int, std::string> > Atom2Name;
	Atom2Name dictionary_;
public:
	bool addAtom(int atom);
	bool setName(int atom, const std::string& name);
	void generate();
	const std::string& getName(int atom) const; // throws NoName
};

#endif
