// $Id: program_impl.h,v 1.5 2004/08/02 18:34:42 jean Exp $

#ifndef PLATYPUS_PROGRAM_IMPL_H
#define PLATYPUS_PROGRAM_IMPL_H

#include <string>
#include <iosfwd>
#include <vector>
#include <map>
#include <memory>
#include <interfaces/from_idl/interfaces_fwd.h>
#include <interfaces/from_idl/program.h>

namespace Platypus
{
	const char* const EMPTY_PROGRAM = "0\n0\nB+\n0\nB-\n0\n1\n";

	typedef ProgramInterface< std::vector<AtomId> > ProgramInterfaceType;
	class Program : public ProgramInterfaceType
	{
	public:
		typedef std::map<AtomId, std::string> Id2Name;
		typedef std::map<std::string, AtomId> Name2Id;
	private:
		Id2Name ids_;
		Name2Id names_;
		CollectionType atoms_;
		std::string lparse_;		

		void setupMappings(std::istream& is); 
	public:
		Program();
		
		// 
		virtual void setup(const std::string& input);
		virtual void setup(std::istream& input);

		// returns the associated name for an atom
		const std::string& idToName(AtomId id) const;
		
		// returns the id associated with an atom name
		// NOTE: 	Names MUST be returned for all atoms, wether
		// 			they have a "name" (like a, p(v4), ...) or not.	
		AtomId nameToId(const std::string& name) const;
		
		// returns the collection of atoms of the logic program
		const CollectionType& atoms() const;
		
		// Returns the definite number of atoms in the logic program.
		// For instance the logic program
		// d :- {c} 1.
		// c.
		//
		// after being preprocessed by lparse contains FOUR atoms.
		size_t numberOfAtoms() const;	
		
		// returns true if the atom had a name in the original (textual program), false otherwise.
		bool hasDisplayName(AtomId id) const;	
		
		// returns an lparse representation of the preprocessed program.
		const std::string& lparse() const;
	};
	typedef Program ProgramType;
}

#endif
