// $Id: smodels_wrapper.cpp,v 1.2 2004/08/05 07:51:14 jean Exp $

#include <iostream>
#include <cassert>
#include <algorithm>
#include <interfaces/smodels_wrapper.h>
#include <smodels/smodels.h>
#include <smodels/api.h>
#include <smodels/read.h>
#include <smodels/atomrule.h>

using namespace std;

namespace Platypus
{
	SmodelsHolder::~SmodelsHolder()
	{}
	SmodelsHolder::SmodelsHolder(const Api* api)
		:	smodels_(new Smodels)
		,	api_(new Api(&smodels_->program))
	{
		api_->remember();
		if(!api)
			throw SmodelsWrapperError("Api pointer is NULL!");
		if(api->done_)
			throw SmodelsWrapperError("Api::done() has been called!");
		api_->copy(api);
	}
	Smodels* SmodelsHolder::finalize() 
	{
		if(!good())
			throw SmodelsWrapperError("Already called finalize!");
		
		api_->done();
		api_.reset();
		smodels_->init();
		return smodels_.release();
	}
	SmodelsHolder::const_iterator SmodelsHolder::begin() const { return const_iterator(smodels_->program.atoms.head()); }
	SmodelsHolder::const_iterator SmodelsHolder::end() const { return const_iterator(); }
	bool SmodelsHolder::addComputeStatement(const_iterator it, bool setTrue)
	{
		if(!good())
			throw SmodelsWrapperError("Already called finalize!");

		assert(std::distance(it, end()) > 0);

		api_->set_compute(const_cast< ::Atom* >(&*it), setTrue);
		return true;
	}


	SmodelsHolderFactory::~SmodelsHolderFactory()
	{}
	SmodelsHolderFactory::SmodelsHolderFactory(std::istream& is)
		:	smodels_(new Smodels)
		,	api_(new Api(&smodels_->program))
	{
		Read reader(&smodels_->program, api_.get());
		if(reader.read(is))
			throw SmodelsWrapperError("Error in input!");
	}
	SmodelsHolderFactory::SmodelsHolderFactory(const Api* api)
		:	smodels_(new Smodels)
		,	api_(new Api(&smodels_->program))
	{
		if(api->done_)
			throw SmodelsWrapperError("Api::done() has been called!");
		api_->copy(api);
	}
	SmodelsHolder* SmodelsHolderFactory::create() const
	{
		std::auto_ptr<SmodelsHolder> temp(new SmodelsHolder(api_.get()));
		return temp.release();
	}
	

}
