// $Id: strong_smodels_expander_impl.h,v 1.1 2004/09/15 09:07:09 sthiele Exp $

#ifndef PLATYPUS_STRONG_SMODELS_EXPANDER_IMPL_H
#define PLATYPUS_STRONG_SMODELS_EXPANDER_IMPL_H

#include <memory>
#include <iosfwd>
#include <interfaces/utility.h>
#include <interfaces/smodels_wrapper.h>

#include <smodels/stable.h>

class Api;
class Atom;
class Node;
class Smodels;
namespace Platypus
{
	class PartialModel;
	class SmodelsEnhancedProgram;
	class StrongSmodelsExpander : NoDefaultConstruction
	{
		typedef SmodelsAtomsIterator iterator;
		typedef SmodelsAtomsConstIterator const_iterator;

		std::auto_ptr<Stable> stable_;

		const_iterator begin() const;
		const_iterator end() const;
		


	public:
		std::string sm_choice;
		bool ispos;
		
		~StrongSmodelsExpander();
		StrongSmodelsExpander(std::istream& is);

		void expand(const std::string& name, bool setTrue);
		void backtrackTo(const std::string& name);
	
		bool hasConflict() const;
		bool hasUnknown() const;

		void update(PartialModel& partialModel) const;
	};
}

#endif
