// $Id: test_name_generator.cpp,v 1.3 2004/08/02 18:34:46 jean Exp $

#include <iostream>
#include <string>
#include <cppunit/TestCase.h>
#include <cppunit/TestCaller.h>
#include <cppunit/TestResult.h>
#include <cppunit/TestSuite.h>
#include <cppunit/extensions/HelperMacros.h>
#include <interfaces/name_generator.h>

using namespace std;


class NameGeneratorTest : public CppUnit::TestFixture
{	
public:
	void testCtor()
	{
		NameGenerator g;
		try
		{
			g.getName(8);
			CPPUNIT_ASSERT(false);
		}
		catch(const NoName&)
		{}
	}
	void testForgetGenerate()
	{
		NameGenerator g;
		g.addAtom(1);
		g.addAtom(2);
		try
		{
			g.getName(1);
			CPPUNIT_ASSERT(false);
		}
		catch(const NoName&)
		{}
	}
	void testNoAtom()
	{
		NameGenerator g;
		g.addAtom(1);
		g.addAtom(2);
		g.generate();
		try
		{
			g.getName(3);
			CPPUNIT_ASSERT(false);
		}
		catch(const NoName&)
		{}
	}
	
	void testGenerate()
	{
		NameGenerator g;
		g.addAtom(1);
		g.addAtom(2);
		g.addAtom(3);
		g.setName(3, "foo");
		g.generate();
		const string PREFIX = "_invisible-";
		
		CPPUNIT_ASSERT_EQUAL(g.getName(1).substr(0, PREFIX.size()), PREFIX);
		CPPUNIT_ASSERT_EQUAL(g.getName(2).substr(0, PREFIX.size()), PREFIX);
		CPPUNIT_ASSERT_EQUAL(g.getName(3), string("foo"));
	}
	CPPUNIT_TEST_SUITE( NameGeneratorTest );
		CPPUNIT_TEST( testCtor );
		CPPUNIT_TEST( testForgetGenerate );
		CPPUNIT_TEST( testNoAtom );
		CPPUNIT_TEST( testGenerate );
		
	CPPUNIT_TEST_SUITE_END();
};


CPPUNIT_TEST_SUITE_REGISTRATION( NameGeneratorTest );


