// $Id: test_partial_model_impl.cpp,v 1.3 2004/08/02 18:34:46 jean Exp $

#include <iostream>
#include <string>
#include <algorithm>
#include <fstream>
#include <functional>
#include <cppunit/TestCase.h>
#include <cppunit/TestCaller.h>
#include <cppunit/TestResult.h>
#include <cppunit/TestSuite.h>
#include <cppunit/extensions/HelperMacros.h>
#include <interfaces/partial_model_impl.h>
#include <interfaces/atom.h>
#include <interfaces/program_impl.h>
#include <interfaces/smodels_program_impl.h>
#include <interfaces/program_factory.h>
#include <test/program_metadata.h>
using namespace std;
using namespace Platypus;

namespace
{
	struct FindByName : public std::unary_function<Platypus::Atom, bool>
	{
		typedef std::unary_function<Platypus::Atom, bool> Base;
		const std::string& name_;
		FindByName(const std::string& name)
			:	name_(name)
		{}
		inline bool operator()(const Atom& atom) const
		{
			return atom.name() == name_;
		}
	};
}

class PartialModelTest : public CppUnit::TestFixture
{
	ProgramMetaData* metaData_;
public:
	void setUp()
	{
		ifstream in("metadata.txt");
		CPPUNIT_ASSERT(in);
		metaData_ = new ProgramMetaData(in);
	}
	void tearDown()
	{
		delete metaData_;
	}
	PartialModel getPartialModel(const char* filename)
	{
		Program& p = ProgramFactory::instance().create();
		ifstream in(filename);
		CPPUNIT_ASSERT(in);
		p.setup(in);
		
		return PartialModel(p);
	}
	void testCtor()
	{
		PartialModel pm(getPartialModel("usualcases.lparse"));

		const MetaData& md = metaData_->get("usualcases.lparse");
		
		CPPUNIT_ASSERT_EQUAL(pm.hasUnknown(), true);
		CPPUNIT_ASSERT_EQUAL((size_t)pm.positiveAtoms().size(), (size_t)0);
		CPPUNIT_ASSERT_EQUAL((size_t)pm.negativeAtoms().size(), (size_t)0);
		CPPUNIT_ASSERT_EQUAL((size_t)pm.unknownAtoms().size(), (size_t)md.atoms_);

	}

	void testSetTruthValue()
	{
		PartialModel pm(getPartialModel("usualcases.lparse"));

		const MetaData& md = metaData_->get("usualcases.lparse");
		

		Atom p(*find_if(pm.unknownAtoms().begin(), pm.unknownAtoms().end(), FindByName("p")));
		pm.setFalse(p);

		Atom i(*find_if(pm.unknownAtoms().begin(), pm.unknownAtoms().end(), FindByName("i")));
		pm.setFalse(i);

		Atom h(*find_if(pm.unknownAtoms().begin(), pm.unknownAtoms().end(), FindByName("h")));
		pm.setTrue(h);
		
		CPPUNIT_ASSERT_EQUAL(pm.hasUnknown(), true);
		CPPUNIT_ASSERT_EQUAL((size_t)pm.positiveAtoms().size(), (size_t)1);
		CPPUNIT_ASSERT_EQUAL((size_t)pm.negativeAtoms().size(), (size_t)2);
		CPPUNIT_ASSERT_EQUAL((size_t)pm.unknownAtoms().size(), (size_t)md.atoms_-3);

		pm.setTrue(i);
		pm.setFalse(h);

		pm.setUnknown(p);

		CPPUNIT_ASSERT_EQUAL(pm.hasUnknown(), true);
		CPPUNIT_ASSERT_EQUAL((size_t)pm.positiveAtoms().size(), (size_t)1);
		CPPUNIT_ASSERT_EQUAL((size_t)pm.negativeAtoms().size(), (size_t)1);
		CPPUNIT_ASSERT_EQUAL((size_t)pm.unknownAtoms().size(), (size_t)md.atoms_-2);		
	}
	
	CPPUNIT_TEST_SUITE( PartialModelTest );
		CPPUNIT_TEST( testCtor );
		CPPUNIT_TEST( testSetTruthValue );
	CPPUNIT_TEST_SUITE_END();
};


CPPUNIT_TEST_SUITE_REGISTRATION( PartialModelTest );


