// $Id: test_program_impl.cpp,v 1.7 2004/08/02 18:34:46 jean Exp $

#include <iostream>
#include <string>
#include <algorithm>
#include <fstream>
#include <cppunit/TestCase.h>
#include <cppunit/TestCaller.h>
#include <cppunit/TestResult.h>
#include <cppunit/TestSuite.h>
#include <cppunit/extensions/HelperMacros.h>
#include <interfaces/program_factory.h>
#include <interfaces/smodels_program_impl.h>
#include <interfaces/program_impl.h>
#include <test/program_metadata.h>

using namespace std;
using namespace Platypus;

class ProgramImplTest : public CppUnit::TestFixture
{
	ProgramMetaData* metaData_;
	void testFile(const char* filename)
	{
		CPPUNIT_ASSERT(filename);
		ifstream in(filename);
		CPPUNIT_ASSERT(in);

		Program& p = ProgramFactory::instance().create();
		p.setup(in);
		const MetaData& md = metaData_->get(filename);

		CPPUNIT_ASSERT_EQUAL((size_t)p.numberOfAtoms(), (size_t) md.atoms_);
		CPPUNIT_ASSERT_EQUAL((size_t)p.atoms().size(), (size_t) md.atoms_);

		for(ProgramType::CollectionType::const_iterator it = p.atoms().begin();
			it != p.atoms().begin(); ++it)
		{
			CPPUNIT_ASSERT(*it >= 1 && *it <= (unsigned)md.atoms_);
			if(p.hasDisplayName(*it))
			{
				CPPUNIT_ASSERT_EQUAL(md.hasAtomName(p.idToName(*it)), true); 
			}
			else
			{
				CPPUNIT_ASSERT_EQUAL(p.idToName(*it)[0], '_');
			}
		}
		// check lparse output (manually)
		if(0)
		{
			ofstream out((string("check_") + filename).c_str());
			CPPUNIT_ASSERT(out);
			out << p.lparse();
		}
	}
public:
	void setUp()
	{
		ifstream in("metadata.txt");
		CPPUNIT_ASSERT(in);
		metaData_ = new ProgramMetaData(in);
	}
	void tearDown()
	{
		delete metaData_;
	}
	void testCtor()
	{
		Program& p = ProgramFactory::instance().create();
		p.setup(EMPTY_PROGRAM);
		CPPUNIT_ASSERT_EQUAL((size_t)p.numberOfAtoms(), (size_t) 0);
		CPPUNIT_ASSERT_EQUAL((size_t)p.atoms().size(), (size_t) 0);
		CPPUNIT_ASSERT_EQUAL(p.lparse(), string(EMPTY_PROGRAM));

		try
		{
			p.idToName(0);
			CPPUNIT_ASSERT(false);
		}
		catch(UnknownAtom&)
		{}
		
		try
		{
			p.nameToId("foo");
			CPPUNIT_ASSERT(false);
		}
		catch(UnknownAtom&)
		{}

		try
		{
			p.hasDisplayName(2);
			CPPUNIT_ASSERT(false);
		}
		catch(UnknownAtom&)
		{}

	}

	void testUsualcases()
	{
		testFile("usualcases.lparse");
	}
	void testHamilton()
	{
		testFile("ham_comp_3.lparse");
	}
	void testColor()
	{
		testFile("color-3-4.lparse");
	}
	void testPigeon()
	{
		testFile("pigeon-3-4.lparse");
	}
	void testSchur()
	{
		testFile("schur-3-3.lparse");
	}
	
	CPPUNIT_TEST_SUITE( ProgramImplTest );
		CPPUNIT_TEST( testCtor );
		CPPUNIT_TEST( testUsualcases );
		CPPUNIT_TEST( testHamilton );	
		CPPUNIT_TEST( testColor );	
		CPPUNIT_TEST( testPigeon );	
		CPPUNIT_TEST( testSchur );
	CPPUNIT_TEST_SUITE_END();
};


CPPUNIT_TEST_SUITE_REGISTRATION( ProgramImplTest );


