// $Id: choice.h,v 1.4 2005/01/17 20:26:32 rtichy Exp $

#ifndef PLATYPUS_CHOICE_H
#define PLATYPUS_CHOICE_H

#include <interfaces/from_idl/interfaces_fwd.h>
#include <interfaces/atom.h>
#include <interfaces/utility.h>
#include <interfaces/partial_model_impl.h>
#include <iostream>

using namespace std;

namespace Platypus
{
  class Choice : public NoDefaultConstruction
    {
    public:
      AtomType atom_;
      bool positive_;
      bool expired_;
      Choice(const AtomType& atom, bool positive, bool expired = false)
	:	atom_(atom)
	,	positive_(positive)
	,       expired_(expired)
	{}

      friend bool operator==(const Choice& lhs, const Choice& rhs)
	{
	  return lhs.atom_ == rhs.atom_ && lhs.positive_ == rhs.positive_;
	}
      
      friend bool operator!=(const Choice& lhs, const Choice& rhs)
	{
	  return !(lhs == rhs);
	}
    };
  
	typedef Choice ChoiceType;
	
	

	template<class PartialModelT> 
	  class DelegatableChoice : public Choice
	  {
	  public:
	    typedef PartialModelT PartialModelType;
	    PartialModelType partialModel_;
	    DelegatableChoice(const AtomType& atom, bool positive, const PartialModelType& pm)
	      :	Choice(atom, positive)
	      ,	partialModel_(pm)
	      {}
	    
	  };
	
	typedef DelegatableChoice<PartialModelType> DelegatableChoiceType;

	template<class T>
	bool operator==(const DelegatableChoice<T>& lhs, const DelegatableChoice<T>& rhs)
	{
		return (const Choice&)lhs == (const Choice&)rhs && lhs.partialModel_ == rhs.partialModel_;
	}
	
	template<class T>
	bool operator!=(const DelegatableChoice<T>& lhs, const DelegatableChoice<T>& rhs)
	{
		return !(lhs == rhs);
	}
	
	template<class T>
	  std::ostream & operator<<(std::ostream & os, const DelegatableChoice<T> & choice){
	  
	  os << "name: " << choice.atom_.name() << endl;
	  os << "positive: " << choice.positive_ << endl;
	  os << choice.partialModel_ << endl;
	  
	  return os;
	  
	}
	
	  
};


#endif
