// $Id: chooser_impl.h,v 1.3 2004/08/01 11:37:46 jean Exp $

#ifndef PLATYPUS_CHOOSER_IMPL
#define PLATYPUS_CHOOSER_IMPL

#include <interfaces/from_idl/exception.h>
#include <interfaces/from_idl/chooser.h>
#include <interfaces/partial_model_impl.h>
#include <interfaces/program_impl.h>
#include <interfaces/choice.h>

namespace Platypus
{
	class ChooseFirstUnknown : public ChooserInterface
	{
		PartialModelType& partialModel_;
	public:
		ChooseFirstUnknown(PartialModelType& pm, const ProgramType&)
			:	partialModel_(pm)
		{}
		Choice makeChoice()
		{
			if(!partialModel_.hasUnknown())
				throw NoChoiceLeft();

			Choice c(*partialModel_.unknownAtoms().begin(), true);
			partialModel_.setTrue(c.atom_);
			return c;
		}
	};
}

#endif
