// $Id: expander.h,v 1.3 2004/08/01 11:37:49 jean Exp $

#ifndef PLATYPUS_EXPANDER_H
#define PLATYPUS_EXPANDER_H

#include <interfaces/utility.h>
#include <interfaces/from_idl/exception.h>
#include <interfaces/from_idl/interfaces_fwd.h>

namespace Platypus
{
	// The smodels encapsulation. An implementation of this
	// interface is required to carry state. This state is
	// refered to as internal partial model.
	template<class PartialModelT, class ChoiceT>
	class ExpanderInterface : public NoDefaultConstruction
	{
	protected:
		ExpanderInterface() {}
	public:
		virtual ~ExpanderInterface() {}
		typedef PartialModelT PartialModelType;
		typedef ChoiceT ChoiceType;
		
		// Describe the state the Expander is in
		// In order to allow for multiple
		// states to happen at once these
		// are defined as constants and OR'd
		// together.
		typedef unsigned long ExpanderState;
		
		// initializer
		static const ExpanderState NIL;
		// unknown atoms exists in the partial model 
		static const ExpanderState HAS_UNKNOWN;
		// Expander has detected a conflict
		static const ExpanderState HAS_CONFLICT;
		
		
		// returns the current state of the Expander
		// OR'd together
		// This could be any combination of the 
		// values above except those hat mutually
		// exclude each other
		// So a valid state would be HAS_UNKNOWN | HAS_CONFLICT
		// or HAS_ANSWER_SET.
		virtual ExpanderState state() const = 0;
		
		// shall return false whether the Expander is in shape
		// for another call to expand, true otherwise.
		virtual bool done() const = 0;
		
		// expands the partial model located in the implementation
		// of the Expander with the choice passed.	
		virtual void expand(const ChoiceType& choice) = 0;
		
		// returns a PartialModel representation of the internal
		// partial model. 
		virtual PartialModelType partialModel() const = 0;
		
		// backtracks the internal partial model to the choice indicated
		// by the argument. If no choice has been made the corresponding
		// exception shall be raised. The method shall raise 
		// NoTruthValue if the atom specified has not yet been assigned
		// a truth value (that is it wasn't a choice or is yet to be one).
		virtual void backtrackTo(const Atom& choice) = 0;
	};

	template<class PartialModelT, class ChoiceT>
		const typename ExpanderInterface<PartialModelT, ChoiceT>::ExpanderState 
		ExpanderInterface<PartialModelT, ChoiceT>::NIL = 0;

	template<class PartialModelT, class ChoiceT>
		const typename ExpanderInterface<PartialModelT, ChoiceT>::ExpanderState 
		ExpanderInterface<PartialModelT, ChoiceT>::HAS_UNKNOWN = 1<<0;

	template<class PartialModelT, class ChoiceT>
		const typename ExpanderInterface<PartialModelT, ChoiceT>::ExpanderState 
		ExpanderInterface<PartialModelT, ChoiceT>::HAS_CONFLICT = 1<<1;
}

#endif
