// $Id: program.h,v 1.2 2004/08/01 11:37:50 jean Exp $

#ifndef PLATYPUS_PROGRAM_H
#define PLATYPUS_PROGRAM_H

#include <interfaces/utility.h>
#include <interfaces/from_idl/exception.h>
#include <interfaces/from_idl/interfaces_fwd.h>
#include <string>

namespace Platypus
{
	// Program shall represent the logic program (the set of lines we call rules)
	// in a lparse related way.
	template<class CollectionT>
	class ProgramInterface : public NoCopyNoAssignment
	{
	protected:
		ProgramInterface() {}
	public:
		typedef CollectionT CollectionType;
		virtual ~ProgramInterface() {}
		
		// returns the associated name for an atom
		virtual const std::string& idToName(AtomId id) const = 0;
		
		// returns the id associated with an atom name
		// NOTE: 	Names MUST be returned for all atoms, wether
		// 			they have a "name" (like a, p(v4), ...) or not.	
		virtual AtomId nameToId(const std::string& name) const = 0;
		
		// returns the collection of atoms of the logic program
		virtual const CollectionType& atoms() const = 0;
		
		// Returns the definite number of atoms in the logic program.
		// For instance the logic program
		// d :- {c} 1.
		// c.
		//
		// after being preprocessed by lparse contains FOUR atoms.
		virtual size_t numberOfAtoms() const = 0;	
		
		// returns true if the atom had a name in the original (textual program), false otherwise.
		virtual bool hasDisplayName(AtomId id) const = 0;	
		
		// returns an lparse representation of the preprocessed program.
		virtual const std::string& lparse() const = 0;
	};
	
};

#endif 

