// $Id: partial_model_impl.h,v 1.5 2004/12/02 21:46:16 rtichy Exp $

#ifndef PLATYPUS_PARTIAL_MODEL_IMPL_H
#define PLATYPUS_PARTIAL_MODEL_IMPL_H

//#include <iosfwd>
#include <iostream>
#include <vector>
#include <list>
#include <interfaces/utility.h>
#include <interfaces/from_idl/interfaces_fwd.h>
#include <interfaces/from_idl/partial_model.h>

namespace Platypus
{
	class Atom;
	class Program;
	typedef PartialModelInterface< std::list<Atom> > PartialModelInterfaceType;
	class PartialModel : 	public NoDefaultConstruction,
							public PartialModelInterfaceType
	{
		CollectionType positive_;
		CollectionType negative_;
		CollectionType unknown_;
		void moveAtom(const Atom& atom, CollectionType& to);
	public:
		// initializes the partial model to all 
		// atoms unknown
		PartialModel(const Program& program);
		template<class T>
		PartialModel(	T posBegin, T posEnd,
						T negBegin, T negEnd,
						T unkBegin, T unkEnd,
						const Program& program)
			:	positive_(posBegin, posEnd)
			,	negative_(negBegin, negEnd)
			,	unknown_(unkBegin, unkEnd)
		{
			// no validating is needed, atoms are implicitly valid
			// The atom's c'tor checks whether the atom apears in the 
			// logic program.
		}
		void setTrue(const Atom& atom);
		void setFalse(const Atom& atom);
		void setUnknown(const Atom& atom);
		
		// returns true, if there are unknown atoms left in the partial model, false otherwise
		bool hasUnknown() const;
			
		const CollectionType& positiveAtoms() const ;
		const CollectionType& negativeAtoms() const;
		const CollectionType& unknownAtoms() const;
		void reset();
		
	};
	typedef PartialModel PartialModelType;

	bool operator==(const PartialModelType& lhs, const PartialModelType& rhs);
	inline bool operator!=(const PartialModelType& lhs, const PartialModelType& rhs)
	{
		return !(lhs == rhs);
	}
	std::ostream & operator<<(std::ostream & os, const PartialModel & model);

};

#endif
