// $Id: smodels_expander_impl.h,v 1.4 2004/08/02 18:34:43 jean Exp $

#ifndef PLATYPUS_SMODELS_EXPANDER_IMPL_H
#define PLATYPUS_SMODELS_EXPANDER_IMPL_H

#include <memory>
#include <iosfwd>
#include <interfaces/utility.h>
#include <interfaces/smodels_wrapper.h>

class Api;
class Atom;
class Node;
class Smodels;
namespace Platypus
{
	class PartialModel;
	class SmodelsEnhancedProgram;
	class SmodelsExpander : NoDefaultConstruction
	{
		typedef SmodelsAtomsIterator iterator;
		typedef SmodelsAtomsConstIterator const_iterator;

		std::auto_ptr<Smodels> smodels_;

		const_iterator begin() const;
		const_iterator end() const;
		void addComputeStatements(Api& api_, const PartialModel& partialModel);
		void addComputeStatements(SmodelsHolder* holder, const PartialModel& partialModel);
		void finalize(Api& api_);
		void finalize(SmodelsHolder* holder);		
	public:
		~SmodelsExpander();
		SmodelsExpander(const SmodelsEnhancedProgram& program, const PartialModel& partialModel);
		SmodelsExpander(const Api& api, const PartialModel& partialModel);
		SmodelsExpander(std::istream& is);
		void expand();
		void makeChoice(const std::string& name, bool setTrue);
		void backtrackTo(const std::string& name);
	
		bool hasConflict() const;
		bool hasUnknown() const;

		void update(PartialModel& partialModel) const;
	};
}

#endif
