// $Id: smodels_wrapper.h,v 1.2 2004/08/05 07:51:14 jean Exp $

#ifndef PLATYPUS_SMODELS_WRAPPER_H
#define PLATYPUS_SMODELS_WRAPPER_H

#include <stdexcept>
#include <string>
#include <memory>
#include <iosfwd>
#include <iterator>

#ifdef LACKS_ITERATOR
namespace std
{
	template
	<
		class Category,
		class Type,
		class Distance = ptrdiff_t,
		class Pointer = Type*,
		class Reference = Type&
	>
   	struct iterator {
   		typedef Category iterator_category;
   		typedef Type value_type;
   		typedef Distance difference_type;
   		typedef Pointer pointer;
   		typedef Reference reference;
   	};
}
#endif


class Api;
class Smodels;
class Atom;
class Node;
namespace Platypus
{
	struct SmodelsWrapperError : public std::logic_error
	{
		SmodelsWrapperError(const std::string& reason)
			:	std::logic_error(reason)
		{}
	};

	template<class T>
	class Iterator : public std::iterator<std::forward_iterator_tag, T> 
	{
		typedef std::iterator<std::forward_iterator_tag, T> Base;
		::Node* current_;
	public:
		typedef typename Base::pointer pointer;
		typedef typename Base::reference reference;
		operator const void*() const { return current_; }
		Iterator(::Node* node = 0)
			:	current_(node)
		{}
		pointer operator->() const
		{
			return current_->atom;
		}
		reference operator*() const
		{
			return *(current_->atom);
		}
		Iterator& operator++()
		{
			if(current_)
				current_ = current_->next;
			return *this;
		}
		Iterator operator++(int)
		{
			Iterator temp(*this);
			++(*this);
			return temp;
		}
	};
	typedef Iterator< ::Atom > SmodelsAtomsIterator;
	typedef Iterator<const ::Atom> SmodelsAtomsConstIterator;


	class SmodelsHolder
	{
		std::auto_ptr< ::Smodels > smodels_;
		std::auto_ptr< ::Api > api_;
		SmodelsHolder();
		SmodelsHolder(const SmodelsHolder&);
		SmodelsHolder& operator=(const SmodelsHolder&);
	public:
		~SmodelsHolder();
		typedef SmodelsAtomsConstIterator const_iterator;
		inline bool good() const { return smodels_.get() != 0; }
		inline operator const bool() const { return good(); }
		SmodelsHolder(const Api* api);
		Smodels* finalize();
		const_iterator begin() const;
		const_iterator end() const;
		bool addComputeStatement(const_iterator it, bool setTrue);
	};

	class SmodelsHolderFactory
	{
		std::auto_ptr< ::Smodels > smodels_;
		std::auto_ptr< ::Api > api_;

		SmodelsHolderFactory();
		SmodelsHolderFactory(const SmodelsHolderFactory&);
		SmodelsHolderFactory& operator=(const SmodelsHolderFactory&);
	public:
		~SmodelsHolderFactory();
		SmodelsHolderFactory(std::istream& is);		
		SmodelsHolderFactory(const Api* api);
		SmodelsHolder* create() const;
	};

};

#endif
