#ifndef __SHARED__MEMORY__H__
#define __SHARED__MEMORY__H__

/*===============================================================
 * SharedMemory.h
 * Richard Tichy
 *
 * File contains the platypus shared memory structure and the
 * method to initialize the valhues within the shared memory
 * structure.
 *
 * Modifications:
 *     May 25th - doxygen style commenting complete
 *===============================================================*/

#include <sys/types.h>
#include <unistd.h>

namespace Platypus{

  const int MAX_NUM_PROCESSES = 200;
  
  typedef struct shared_mem{
    
    int numAnswerSets;
    int forks;
    int nodes;
    int first_pid;
    int maxNumberOfForks;
    
    pid_t ppids[MAX_NUM_PROCESSES];
    int ppidWaiting[MAX_NUM_PROCESSES];
    int pidIndex;
    
  }SharedMemory;

  /**
   * Initialize the values in the shared memory structure SharedMemory.
   *
   *@param SharedMemory * shm - pointer to the shared memory structure
   *@param int maxProcesses - the maximum number of processes to run
   */   
  void initSharedMemory(SharedMemory *shm, int maxProcesses);
  
}

#endif
