#define __COMMAND_LINE_PARSER_UNIT_TEST__ 0

/*======================================================================
 * CommandLineParser.cc
 * Richard Tichy
 *
 * Modifications:
 *     May 25th - code level commenting completed
 *=====================================================================*/

#include "command_line_parser.h"

using namespace Platypus;

//add an argument to this object
void CommandLineParser::_addArg(const char * arg){
  
  string in(arg);
  this->_args.push_back(in);
  
}

//process the command line arguments
bool CommandLineParser::processArgs(int argc, char **argv){
  
  bool dataSet = false;

  //add the copmmand line arguments
  for (int c = 1; c < argc; c++){
    this->_addArg(argv[c]);
  }
 
  //check if only a file name was specified
  if(this->_args.size() == 1){
    if(this->_args[0][0] != '-'){
      this->_file = this->_args[0];
      this->_fileSet = true;
      //return true;
    }
    else{
      return false;
    }
  }
  else{
    for(int i = 0;i < (int)_args.size();i++){
      //deal with the -d data option
      if(this->_args[i] == "-d"){
	if(!dataSet){
	  if(((i+1) < (int)this->_args.size()) && (this->_args[i+1][0] != '-')){
	    this->_data = this->_args[i+1];
	    dataSet = true;
	    i++;
	  }
	  else{
	    return false;
	  }
	}
	else{
	  return false;
	}
      }
      //deal with the -s data option
      else if(this->_args[i] == "-s"){
	this->_suppressed = true;
      }
      else{
	//invalid flag
	if(this->_args[i][0] == '-')
	  return false;

	//make sure it is the last thing on the command line
	if(i == (int)this->_args.size()-1){
	  this->_file = this->_args[i];
	  this->_fileSet = true;
	}
	else{
	  return false;
	}
      }
    }
  }

  return true;

}

//process the command line arguments
bool DistributedCommandLineParser::processArgs(int argc, char **argv){
  
  bool forkSet = false;
  bool dataSet = false;
  bool levelSet = false; 

  //add the copmmand line arguments
  for (int c = 1; c < argc; c++){
    this->_addArg(argv[c]);
  }
 
  //check if only a file name was specified
  if(this->_args.size() == 1){
    if(this->_args[0][0] != '-'){
      this->_file = this->_args[0];
      this->_fileSet = true;
      //return true;
    }
    else{
      return false;
    }
  }
  else{
    for(int i = 0;i < (int)_args.size();i++){
      
      //deal with the -p flag option
      if(this->_args[i] == "-p"){
	if(!forkSet){
	  if(((i+1) < (int)this->_args.size()) && (this->_args[i+1][0] != '-')){
	    this->_processes = atoi(this->_args[i+1].c_str());

	    //make sure parameter was greater than 0
	    if(this->_processes <= 0)
	      return false;

	    forkSet = true;
	    i++;
	  }
	  else{
	    return false;
	  }
	}
	else{
	  return false;	
	}
      }
      //deal with the -d data option
      else if(this->_args[i] == "-d"){
	if(!dataSet){
	  if(((i+1) < (int)this->_args.size()) && (this->_args[i+1][0] != '-')){
	    this->_data = this->_args[i+1];
	    dataSet = true;
	    i++;
	  }
	  else{
	    return false;
	  }
	}
	else{
	  return false;
	}
      }
      //deal with the -l data option
      else if(this->_args[i] == "-l"){
	if(!levelSet){
	  if(((i+1) < (int)this->_args.size()) && (this->_args[i+1][0] != '-')){
	    this->_level = this->_args[i+1];
	    this->_levelSet = true;
	    levelSet = true;
	    i++;
	  }
	  else{
	    return false;
	  }
	}
	else{
	  return false;
	}
      }
      //deal with the -s data option
      else if(this->_args[i] == "-s"){
	this->_suppressed = true;
      }
      else if(this->_args[i] == "-i"){
	this->_internal = true;
      }
      else{
	//invalid flag
	if(this->_args[i][0] == '-')
	  return false;

	//make sure it is the last thing on the command line
	if(i == (int)this->_args.size()-1){
	  this->_file = this->_args[i];
	  this->_fileSet = true;
	}
	else{
	  return false;
	}
      }
    }
  }

  return true;

}

//print the syntax guideline for the program
void CommandLineParser::printUsage() const{
  
  cout << endl << "  /platypus [-p n][-d data_info][data_file | stdin]" << endl << endl;
  cout << "   -d <data_info> prints data set info. to platypus output " << endl; 
  cout << endl << "   -data set can be specified on the command line or through stdin" << endl << endl;

}


//print the syntax guideline for the program
void DistributedCommandLineParser::printUsage() const{
  
  cout << endl << "  /platypus [-p n] [-d data_info] [-l shallow | mid | deep] [-i] [-s] [data_file | stdin]" << endl << endl
       << "   -p <n : n > 0> specify number of forks (for use with forked implementation)" << endl
       << "   -d <data_info> prints data set info. to platypus output." << endl
       << "   -l <shallow | mid | deep> specifies which choice strategy to use." << endl
       << "       shallow - the chronologically latest choice." << endl
       << "       mid - choose the (number of choices) / 2." << endl
       << "       deep - choose the chronologically most recent choice." << endl
       << "   -i pass non-deterministic core instead of the partial assignment." << endl
       << "   -s suppress printing of answers sets to stdout." << endl
       << endl << "   -data set can be specified on the command line or through stdin" << endl << endl;
  
}

//print the data entered after the -d option
void CommandLineParser::printDataSet() const{

  cout << _data;

}

#if __COMMAND_LINE_PARSER_UNIT_TEST__

int main(int argc, char *argv[]){

  CommandLineParser clp;

  if(!clp.processArgs(argc, argv)){

    clp.printUsage();
  }


  return 0;

}

#endif






