// $Id: main.cpp,v 1.3 2004/11/21 15:15:01 sthiele Exp $

#include <iostream>
#include <fstream>
#include <cassert>
#include <memory>
#include <vector>
#include <algorithm>
#include <iterator>
#include <ctime>
#include <interfaces/program_impl.h>
#include <interfaces/smodels_program_impl.h>
#include <interfaces/expander_chooser_impl.h>
#include <interfaces/choicestodo_impl.h>
#include <interfaces/partial_model_impl.h>
#include <interfaces/chooser_impl.h>
#include <interfaces/program_factory.h>

using namespace std;
using namespace Platypus;

namespace
{
	const char* const PROGRAM_NAME = "demo";
	int usage()
	{
		cerr << "usage: " << PROGRAM_NAME << " <filename>" << endl;
		return 1;
	}

	void printPositiveAtoms(const PartialModel& pm)
	{
		copy(pm.positiveAtoms().begin(), pm.positiveAtoms().end(), ostream_iterator<AtomType>(cout, " "));
		cout << endl;
	}
	void printAnswerSet(const PartialModel& pm, unsigned noModels)
	{
		cout << "Answer: " << noModels << "\nStable Model: ";
		printPositiveAtoms(pm);		
	}
}
typedef ChoicesToDo<ChoiceType, std::vector<ChoiceType> > ChoiceToDoType;
typedef DelegatablePolicy<std::vector<ChoiceType> > DelegatablePolicyType;
//typedef ChoicesToDo<DelegatableChoiceType, std::vector<DelegatableChoiceType> > ChoiceToDoType;
//typedef Expander<DelegatableExpanderInterfaceType> ExpanderType;
typedef Expander<LocalExpanderInterfaceType> ExpanderType;
typedef std::auto_ptr<ExpanderType> SafeExpander;
typedef Chronological<std::vector<DelegatableChoiceType> > PolicyType;

int main(int argc, char** argv)
{
	if(argc != 2)
		return usage();
	
	ifstream file(argv[1]);
	if(!file)
	{
		cerr << "Could not open file " << argv[1] << " for reading!" << endl;
		return 1;
	}

	// get start time
	const clock_t tv1 = clock();

	unsigned expanderInits = 0;
	unsigned noModels = 0;
	unsigned conflicts = 0;
	unsigned backtracks = 0;
	try
	{
		SmodelsEnhancedProgram& program = ProgramFactory::instance().create();		
		program.setup(file);
		
		// empty partial model
		PartialModel pm(program);
		DelegatablePolicyType policy;
		ChoiceToDoType choicesToDo(&policy);
		SafeExpander expander(new ExpanderType(pm, program));
		++expanderInits;
		bool extraRun = true;

		while(choicesToDo.hasChoice() || extraRun)
		{
			extraRun = false;
			if(!expander->done())
			{

				ChoiceType c(expander->makeChoice());

//cout<<"choose "<<c.atom_<<" "<<c.positive_<<endl;
				choicesToDo.add(c);
				expander->expand(c);
			}
			else
			{
				if(!(expander->state() & ExpanderType::HAS_CONFLICT))
					printAnswerSet(expander->partialModel(), ++noModels);
				else
					++conflicts;

				if(choicesToDo.hasChoice())
				{
					ChoiceType c = choicesToDo.nextChoice();

					++backtracks;
					expander->backtrackTo(c.atom_);

					extraRun = true;
				}
			}
		}
		const clock_t tv2 = clock();
		const double time = tv2 / (CLOCKS_PER_SEC * 1.0) - tv1 / (CLOCKS_PER_SEC * 1.0);

		cout << "Expander inits: " << expanderInits << endl;
		cout << "Backtracks: " << backtracks << endl;
		cout << "Conflicts: " << conflicts << endl;
		cout << "Total time: " << time << endl;
	}
	catch(const PlatypusException& e)
	{
		cerr << e.what() << endl;
		return 1;
	}
	
	return 0;
}
