// $Id: atom.cpp,v 1.5 2005/02/20 21:37:58 rtichy Exp $

#include <cassert>
#include <iostream>
#include <interfaces/atom.h>

using namespace std;

namespace Platypus
{
	const ProgramInterfaceType* Atom::program_ = 0;
	void Atom::setProgram(const ProgramInterfaceType* p)
	{
		if(program_)
		{
			assert(program_ == p);
		}
		else
		{
			program_ = p;
			assert("[Atom] Pointer to ProgramInterface is NULL" && program_);
		}
	}
	Atom::Atom(AtomId id, const ProgramInterfaceType& prg)
		:	id_(id)
	{
		setProgram(&prg);
		// ensure the exception is raised if the id does not exist
		program_->idToName(id);
	}
	Atom::Atom(const std::string& name, const ProgramInterfaceType& prg)
		:	id_(prg.nameToId(name))
	{
		setProgram(&prg);
	}

	bool operator==(const Atom& lhs, const Atom& rhs)
	{
		return lhs.id() == rhs.id();
	}
	
	bool operator!=(const Atom& lhs, const Atom& rhs)
	{
		return !(lhs == rhs);
	}
	
	std::ostream& operator<<(std::ostream& os, const Atom& atom)
	{
		if(atom.visible())
			os << atom.name();
		return os;
	}
}
