// $Id: atom.h,v 1.3 2005/02/20 21:01:59 rtichy Exp $

#ifndef PLATYPUS_ATOM_H
#define PLATYPUS_ATOM_H

#include <iosfwd>
#include <string>
#include <interfaces/from_idl/interfaces_fwd.h>
#include <interfaces/from_idl/exception.h>
#include <interfaces/program_impl.h>
#include <interfaces/utility.h>

namespace Platypus
{
	class Atom : public NoDefaultConstruction
	{
		AtomId id_;
		static const ProgramInterfaceType* program_;
		void setProgram(const ProgramInterfaceType* p);
	public:		
		Atom(AtomId id, const ProgramInterfaceType& prg);
		Atom(const std::string& name, const ProgramInterfaceType& prg);
		
		AtomId id() const { return id_; }
		bool visible() const { return program_->hasDisplayName(id_); }
		const std::string& name() const { return program_->idToName(id_); }
	};
	
	bool operator==(const Atom& lhs, const Atom& rhs);
	//{
	//return lhs.id() == rhs.id();
	//}
	
	bool operator!=(const Atom& lhs, const Atom& rhs);
	//{
	//return !(lhs == rhs);
	//}
	
	std::ostream& operator<<(std::ostream& os, const Atom& atom);

	typedef Atom AtomType;
	
};

#endif
