// $Id: expander_impl.cpp,v 1.3 2004/08/01 11:37:46 jean Exp $

#include <cassert>
#include <interfaces/expander_impl.h>
#include <interfaces/program_impl.h>

using namespace std;

namespace Platypus
{
	namespace
	{
		// explicit instatiate the Expander with both kinds of interfaces
		// NOTE: this checks if all methods compile
		template class Expander<LocalExpanderInterfaceType>;
		template class Expander<DelegatableExpanderInterfaceType>;
	}

	std::string InjectConstraints::formatLparse(const PartialModelType& partialModel, const Program& program)
	{
		string output, line;
		stringstream s(program.lparse());
		bool readingBPlus = false;
		bool readingBMinus = false;
		while(getline(s, line))
		{
			if(line.empty())
				continue;

			if(line == "B+")
			{
				output += "B+\n";	
				readingBPlus = true;
				continue;
			}

			if(readingBPlus)
			{
				if(line == "0")
				{
					readingBPlus = false;
					readingBMinus = true;

					for(PartialModelType::CollectionType::const_iterator it = partialModel.positiveAtoms().begin();
						it != partialModel.positiveAtoms().end(); ++it)
					{
						stringstream id;
						id << it->id() << '\n';
						output += id.str();
					}
					output += "0\n";
					continue;
				}					
				
			}

			if(readingBMinus)
			{
				if(line == "0")
				{
					readingBMinus = false;

					for(PartialModelType::CollectionType::const_iterator it = partialModel.negativeAtoms().begin();
						it != partialModel.negativeAtoms().end(); ++it)
					{
						stringstream id;
						id << it->id() << '\n';
						output += id.str();
					}
					output += "0\n";
					continue;
				}					
				
			}

			output += line;
			output += '\n';
		}
		return output;
	}

	InjectConstraints::InjectConstraints(const PartialModelType& partialModel, const Program& program)
		:	stream_(formatLparse(partialModel, program))
	{}
	std::stringstream& InjectConstraints::stream() 
	{
		return stream_;
	}
}
