// $Id: partial_model.h,v 1.3 2004/08/01 11:37:50 jean Exp $

#ifndef PLATYPUS_PARTIAL_MODEL_H
#define PLATYPUS_PARTIAL_MODEL_H

#include <interfaces/from_idl/exception.h>
#include <interfaces/from_idl/interfaces_fwd.h>

namespace Platypus
{
	template<class CollectionT>
	class PartialModelInterface
	{
	protected:
		PartialModelInterface() {}
	public:
		virtual ~PartialModelInterface() {}
		typedef CollectionT CollectionType;
		
		virtual void setTrue(const Atom& atom) = 0;
		virtual void setFalse(const Atom& atom) = 0;
		virtual void setUnknown(const Atom& atom) = 0;
		
		// returns true, if there are unknown atoms left in the partial model, false otherwise
		virtual bool hasUnknown() const = 0;
			
		virtual const CollectionType& positiveAtoms() const = 0;
		virtual const CollectionType& negativeAtoms() const = 0;
		virtual const CollectionType& unknownAtoms() const = 0;
		virtual void reset() = 0;
	};
}

#endif
