// $Id: parser.h,v 1.2 2004/08/01 11:37:47 jean Exp $

#ifndef PARSER_H
#define PARSER_H

#include <iosfwd>
#include <string>
#include <set>
#include <sstream>
#include <stdexcept>

class LParser;
class LParserCallback
{
public:
	virtual ~LParserCallback() {}
	virtual void setup() {}
	virtual void addRuleLine(const std::string& line) = 0;
	virtual void addAtom(int atom) = 0;
	virtual void setName(int atom, const std::string& name) = 0;
	virtual void addBodyPlusLine(const std::string& line) = 0;
	virtual void addBodyMinusLine(const std::string& line) = 0;
	virtual void addNoModels(unsigned) = 0;
	virtual void done() {}
};

struct ParseError : std::runtime_error
{
	int line_;
	ParseError(const std::string& reason = "", int line = -1)
		:	std::runtime_error(reason)
		,	line_(line)
	{}
};

class LParser
{
	std::istream* input_;
	std::istream* data_;
	LParserCallback* callback_;

	typedef std::set<int> AtomSet;
	bool readBodyAtoms(std::stringstream& s, AtomSet& atoms, int noNegative, int noPositive);
	bool readBasicRule(std::string& line, AtomSet& atoms);
	bool readConstraintRule(std::string& line, AtomSet& atoms);
	bool readChoiceRule(std::string& line, AtomSet& atoms);
	bool readWeightRule(std::string& line, AtomSet& atoms);
	bool readMinimizeRule(std::string& line, AtomSet& atoms);
	bool readRule(std::string& line, AtomSet& atoms);
	bool readAtomName(std::string& line, AtomSet& atoms);
	bool readNoModels(std::string& line);
	bool addAtom(int atom, AtomSet& atoms);
public:
	~LParser();
	LParser();
	LParser(const std::string& input, LParserCallback* callback = 0);
	LParser(std::istream& input, LParserCallback* callback = 0);
	void setInput(const std::string& input);
	void setInput(std::istream& input);
	void setCallback(LParserCallback* callback);
	void parse();
};

#endif
