// $Id: smodels_program_impl.cpp,v 1.2 2004/08/05 07:51:13 jean Exp $

#include <sstream>
#include <interfaces/smodels_program_impl.h>
#include <interfaces/smodels_wrapper.h>

using namespace std;

namespace Platypus
{
	SmodelsEnhancedProgram::~SmodelsEnhancedProgram()
	{
		// quiets compiler warnings about SmodelsHolderFactory
		// having an incomplete type
	}
	SmodelsEnhancedProgram::SmodelsEnhancedProgram()
	{
		init();
	}
	void SmodelsEnhancedProgram::init()
	{
		stringstream s(lparse());
		SafeFactory gcc_295_fix(new SmodelsHolderFactory(s));
		factory_ = gcc_295_fix;
	}
	void SmodelsEnhancedProgram::setup(const std::string& input)
	{
		Program::setup(input);
		init();
	}
	void SmodelsEnhancedProgram::setup(std::istream& input)
	{
		Program::setup(input);
		init();
	}
	SmodelsHolder* SmodelsEnhancedProgram::create() const
	{
		return factory_->create();
	}
}
