// $Id: strong_smodels_expander_impl.cpp,v 1.4 2005/02/20 21:10:08 rtichy Exp $

#include <cassert>
#include <vector>
#include <algorithm>
#include <iostream>
#include <functional>
#include <interfaces/strong_smodels_expander_impl.h>
#include <interfaces/atom.h>
#include <interfaces/partial_model_impl.h>
#include <interfaces/from_idl/exception.h>
#include <smodels/read.h>
#include <smodels/smodels.h>
#include <smodels/api.h>
#include <smodels/atomrule.h>

#include <smodels/stable.h>

using namespace std;

namespace Platypus
{
	namespace
	{
		class FindByName : public std::unary_function<std::string, bool>
		{
			std::string name_;
		public:
			FindByName(const std::string& name)
				:	name_(name)
			{}
			bool operator()(const ::Atom& atom) const
			{
				assert(atom.name);
				return name_ == atom.name;
			}
		};
	}



	StrongSmodelsExpander::~StrongSmodelsExpander()
	{
		// inhibits compiler warnings about Smodels being an incomplete type
	}



	StrongSmodelsExpander::StrongSmodelsExpander(std::istream& is)
		:	stable_(new Stable)
	{
		sm_choice="";
		if(stable_->read(is))
				throw ParseError();


		stable_->smodels.setup_with_lookahead();

		if(!stable_->smodels.conflict_found)
		{

			if(!stable_->smodels.stack.full())
			{

				stable_->smodels.heuristic ();
stable_->smodels.improve ();
			}

			::Atom *a;
			a = stable_->smodels.atom[stable_->smodels.hi_index];
			sm_choice=a->name;
			ispos = stable_->smodels.hi_is_positive;

		}
	}



	void StrongSmodelsExpander::expand(const std::string& name, bool setTrue)
	{
		sm_choice="";
		bool foundit = false;

		//first check if we are using smodels choice;
		if(stable_->smodels.atom[stable_->smodels.hi_index]->name==name){
			stable_->smodels.hi_is_positive=setTrue;
			foundit = true;

		}else //find that choice atom by name
		{
			for (long i = 0; i < stable_->smodels.atomtop; i++)
			{
				::Atom *a = stable_->smodels.atom[i];
				assert(a->name);
				if (a->name==name){
					foundit = true;
					if(a->Bpos || a->Bneg)
						throw InvalidChoice();
					stable_->smodels.hi_index=i;
					stable_->smodels.hi_is_positive=setTrue;
					break;
				}
			}
		}
		if(!foundit)
			throw InvalidChoice("[smodels] atom " + name + " is not a valid choice!");


		stable_->smodels.choose();

		if(!stable_->smodels.conflict_found)
		{
			stable_->smodels.dcl.dcl ();
		}
		while (!stable_->smodels.conflict_found && !stable_->smodels.stack.full() && stable_->smodels.lookahead_no_heuristic ())
		{
			stable_->smodels.dcl.dcl ();
		}

		if(!stable_->smodels.conflict_found)
		{

			if(!stable_->smodels.stack.full())
			{
				stable_->smodels.heuristic ();
			}
			::Atom *a;
			a = stable_->smodels.atom[stable_->smodels.hi_index];
			sm_choice=a->name;
			ispos = stable_->smodels.hi_is_positive;

		}

	}

	void StrongSmodelsExpander::backtrackTo(const std::string& name)
	{
		sm_choice="";
		// check with smodels whether there are any choices to
		// backtrack from
		if(stable_->smodels.guesses == 0)
			throw NoChoiceMade();

		// in case we are backtracking for a conflict, reset smodels
		// conflict flag and some queues
		if(stable_->smodels.conflict_found)
		{
			stable_->smodels.conflict();
		}


		::Atom *a = stable_->smodels.stack.pop ();

		// reset the truth value of all atoms succeeding
		// the choice
		// this is an implementation of Smodels::unwind()
		// which unwinds the smodels stack to the choice
		// specified
		while (a->name != name)
		{
			if (a->Bpos)
			{
				if (a->posScore > stable_->smodels.score)
					a->posScore = stable_->smodels.score;
				a->backtrackFromBTrue ();
			}
			else if (a->Bneg)
			{
				if (a->negScore > stable_->smodels.score)
					a->negScore = stable_->smodels.score;
				a->backtrackFromBFalse ();
			}
			if (a->guess != false)
			{
				a->guess = false;
				stable_->smodels.guesses--;
			}
			// assert sanity of this operation by checking if the
			// atom really has been assigned a truth value
			// If we leave this out we'll end up popping the stack
			// empty and not find the atom we are looking for.
			if(stable_->smodels.stack.empty()){throw NoTruthValue();}
			a = stable_->smodels.stack.pop ();
		}


		// now that we have worked our way back to the
		// choice see if its really a choice
		// check if the choice has been made
		if(!a->Bpos && !a->Bneg)
			throw NoTruthValue();

		// check if the atom was a choice
		if(!a->guess)
			throw NoChoiceMade("Atom "  + name + " wasn't a choice");
		else(a->guess=false);
		if (a->Bneg)
		{
			a->backtrackFromBFalse ();
			a->setBTrue ();
		}
		else
		{
			a->backtrackFromBTrue ();
			a->setBFalse ();
		}
		stable_->smodels.stack.push (a);


		while (stable_->smodels.atom[stable_->smodels.atomtop] != a){stable_->smodels.atomtop++;}
		stable_->smodels.atomtop++;


		if(!stable_->smodels.conflict_found)
		{
			stable_->smodels.dcl.dcl ();
		}
		while (!stable_->smodels.conflict_found && !stable_->smodels.stack.full() && stable_->smodels.lookahead_no_heuristic ())
		{
			stable_->smodels.dcl.dcl ();
		}

		if(!stable_->smodels.conflict_found)
		{

			if(!stable_->smodels.stack.full())
			{
				stable_->smodels.heuristic ();
			}
			::Atom *a;
			a = stable_->smodels.atom[stable_->smodels.hi_index];
			sm_choice=a->name;
			ispos = stable_->smodels.hi_is_positive;

		}
	}

	StrongSmodelsExpander::const_iterator StrongSmodelsExpander::begin() const
	{
		return const_iterator(stable_->smodels.program.atoms.head());
	}
	StrongSmodelsExpander::const_iterator StrongSmodelsExpander::end() const
	{
		return const_iterator();
	}
	bool StrongSmodelsExpander::hasConflict() const
	{
		// Smodels::conflict() returns true one
		// time if there has been a conflict, then resets the conflict state
		// -> this is not what we want
		return stable_->smodels.conflict_found;
	}
	bool StrongSmodelsExpander::hasUnknown() const
	{
		return !stable_->smodels.covered();
	}

	// this method assumes that the positive and negative
	// part of the partial model agree with smodels' idea of
	// positive and negative atoms
	void StrongSmodelsExpander::update(PartialModel& partialModel) const
	{
		typedef std::vector< std::pair<Atom, bool> > Atom2Truth;
		Atom2Truth atoms;

		// find all the atoms that are now either positive or negative
		// NOTE: A copy is made to ensure no iterators are invalidated in
		// PartialModel
		for(PartialModel::CollectionType::const_iterator it = partialModel.unknownAtoms().begin();
			it != partialModel.unknownAtoms().end(); ++it)
		{
			const_iterator res = find_if(begin(), end(), FindByName(it->name()));
			assert(res != end());
			if(res->Bpos)
				atoms.push_back(make_pair(*it, true));
			else if(res->Bneg)
				atoms.push_back(make_pair(*it, false));
		}

		// now that we have copies move atoms into their
		// new state
		for(Atom2Truth::const_iterator it = atoms.begin();
			it != atoms.end();	++it)
		{
			if(it->second)
				partialModel.setTrue(it->first);
			else
				partialModel.setFalse(it->first);
		}
	}


}




