// $Id: test_choose_first_unknown.cpp,v 1.1 2004/08/02 18:34:47 jean Exp $

#include <iostream>
#include <string>
#include <algorithm>
#include <fstream>
#include <functional>
#include <cppunit/TestCase.h>
#include <cppunit/TestCaller.h>
#include <cppunit/TestResult.h>
#include <cppunit/TestSuite.h>
#include <cppunit/extensions/HelperMacros.h>
#include <interfaces/partial_model_impl.h>
#include <interfaces/atom.h>
#include <interfaces/program_impl.h>
#include <interfaces/smodels_program_impl.h>
#include <interfaces/program_factory.h>
#include <test/program_metadata.h>
#include <interfaces/choice.h>
#include <interfaces/chooser_impl.h>
using namespace std;
using namespace Platypus;

namespace
{
	struct FindByName : public std::unary_function<Platypus::Atom, bool>
	{
		typedef std::unary_function<Platypus::Atom, bool> Base;
		const std::string& name_;
		FindByName(const std::string& name)
			:	name_(name)
		{}
		inline bool operator()(const Atom& atom) const
		{
			return atom.name() == name_;
		}
	};
}

class ChooseFirstUnknownTest : public CppUnit::TestFixture
{
	ProgramMetaData* metaData_;
public:
	void setUp()
	{
		ifstream in("metadata.txt");
		CPPUNIT_ASSERT(in);
		metaData_ = new ProgramMetaData(in);
	}
	void tearDown()
	{
		delete metaData_;
	}
	
	void testMakeChoice()
	{
		const MetaData& md = metaData_->get("usualcases.lparse");

		Program& p = ProgramFactory::instance().create();
		ifstream in(md.filename_.c_str());
		CPPUNIT_ASSERT(in);
		p.setup(in);

		PartialModel pm(p);

		size_t unknownSize = pm.unknownAtoms().size();
		size_t positiveSize = pm.positiveAtoms().size();
		size_t negativeSize = pm.negativeAtoms().size();
		
		CPPUNIT_ASSERT_EQUAL(pm.hasUnknown(), true);
		CPPUNIT_ASSERT_EQUAL(unknownSize, (size_t)md.atoms_);
		CPPUNIT_ASSERT_EQUAL(positiveSize, (size_t)0);
		CPPUNIT_ASSERT_EQUAL(negativeSize, (size_t)0);

		
		ChooseFirstUnknown chooser(pm, p);
		Choice c(chooser.makeChoice());

		unknownSize = pm.unknownAtoms().size();
		positiveSize = pm.positiveAtoms().size();
		negativeSize = pm.negativeAtoms().size();
		CPPUNIT_ASSERT_EQUAL(c.positive_, true);
		CPPUNIT_ASSERT_EQUAL(pm.hasUnknown(), true);
		CPPUNIT_ASSERT_EQUAL(unknownSize, (size_t)md.atoms_-1);
		CPPUNIT_ASSERT_EQUAL(positiveSize, (size_t)1);
		CPPUNIT_ASSERT_EQUAL(negativeSize, (size_t)0);
		
		CPPUNIT_ASSERT_EQUAL(*pm.positiveAtoms().begin(), c.atom_);
	}

	
	CPPUNIT_TEST_SUITE( ChooseFirstUnknownTest );
		CPPUNIT_TEST( testMakeChoice );
	CPPUNIT_TEST_SUITE_END();
};


CPPUNIT_TEST_SUITE_REGISTRATION( ChooseFirstUnknownTest );


