// $Id: test_constraint_injector.cpp,v 1.3 2004/08/02 18:34:46 jean Exp $

#include <iostream>
#include <string>
#include <sstream>
#include <algorithm>
#include <fstream>
#include <cppunit/TestCase.h>
#include <cppunit/TestCaller.h>
#include <cppunit/TestResult.h>
#include <cppunit/TestSuite.h>
#include <cppunit/extensions/HelperMacros.h>
#include <interfaces/expander_impl.h>
#include <interfaces/atom.h>
#include <interfaces/program_impl.h>
#include <interfaces/smodels_program_impl.h>
#include <interfaces/program_factory.h>
#include <interfaces/partial_model_impl.h>
#include <test/program_metadata.h>

using namespace std;
using namespace Platypus;

class ConstraintInjectorTest : public CppUnit::TestFixture
{
	ProgramMetaData* metaData_;
	Platypus::Atom getAtom(PartialModel& pm, const std::string& name)
	{
		for(PartialModel::CollectionType::const_iterator it = pm.unknownAtoms().begin();
			it != pm.unknownAtoms().end(); ++it)
		{
			if(it->name() == name)
				return *it;
		}

		for(PartialModel::CollectionType::const_iterator it = pm.positiveAtoms().begin();
			it != pm.positiveAtoms().end(); ++it)
		{
			if(it->name() == name)
				return *it;
		}

		for(PartialModel::CollectionType::const_iterator it = pm.negativeAtoms().begin();
			it != pm.negativeAtoms().end(); ++it)
		{
			if(it->name() == name)
				return *it;
		}
		throw 1;
	}
public:
	void setUp()
	{
		ifstream in("metadata.txt");
		CPPUNIT_ASSERT(in);
		metaData_ = new ProgramMetaData(in);
	}
	void tearDown()
	{
		delete metaData_;
	}
	void testEmpty()
	{
		Program& p = ProgramFactory::instance().create();
		p.setup(EMPTY_PROGRAM);
		PartialModel pm(p);
		{
			InjectConstraints injector(pm, p);
			stringstream s;
			s << injector.stream().rdbuf();
			CPPUNIT_ASSERT_EQUAL(s.str(), string(EMPTY_PROGRAM));
		}
	}
	
	void testWithoutConstraint()
	{
		ifstream in("usualcases.lparse");
		CPPUNIT_ASSERT(in);
		ProgramType& p = ProgramFactory::instance().create();
		p.setup(in);
		PartialModel pm(p);
		{
			AtomType i(getAtom(pm, "i"));
			pm.setTrue(i);
			InjectConstraints injector(pm, p);
			stringstream s1, s2;
			s1 << injector.stream().rdbuf();
			ifstream in("usualcases-i-true.lparse");
			CPPUNIT_ASSERT(in);
			s2 << in.rdbuf();
			CPPUNIT_ASSERT_EQUAL(s1.str(), s2.str());
		}
		{
			AtomType i(getAtom(pm, "i"));
			pm.setFalse(i);
			InjectConstraints injector(pm, p);
			stringstream s1, s2;
			s1 << injector.stream().rdbuf();
			ifstream in("usualcases-i-false.lparse");
			CPPUNIT_ASSERT(in);
			s2 << in.rdbuf();
			CPPUNIT_ASSERT_EQUAL(s1.str(), s2.str());
		}

	}
	void testWithOneTrue()
	{
		ifstream in("usualcases-i-true.lparse");
		CPPUNIT_ASSERT(in);
		ProgramType& p = ProgramFactory::instance().create();
		p.setup(in);
		PartialModel pm(p);
		{
			/*
			AtomType i(getAtom(pm, "i"));
			pm.setTrue(i);
			InjectConstraints injector(pm, p);
			stringstream s1, s2;
			s1 << injector.stream().rdbuf();
			ifstream in("usualcases-i-true.lparse");
			CPPUNIT_ASSERT(in);
			s2 << in.rdbuf();
			CPPUNIT_ASSERT_EQUAL(s1.str(), s2.str());
			*/
			// ok
		}
		{
			AtomType i(getAtom(pm, "i"));
			pm.setFalse(i);
			InjectConstraints injector(pm, p);
			stringstream s1, s2;
			s1 << injector.stream().rdbuf();
			ifstream in("usualcases-i-both.lparse");
			CPPUNIT_ASSERT(in);
			s2 << in.rdbuf();
			CPPUNIT_ASSERT_EQUAL(s1.str(), s2.str());
		}

	}
	void testWithOneFalse()
	{
		ifstream in("usualcases-i-false.lparse");
		CPPUNIT_ASSERT(in);
		ProgramType& p = ProgramFactory::instance().create();
		p.setup(in);
		PartialModel pm(p);
		{
			
			AtomType i(getAtom(pm, "i"));
			pm.setTrue(i);
			InjectConstraints injector(pm, p);
			stringstream s1, s2;
			s1 << injector.stream().rdbuf();
			ifstream in("usualcases-i-both.lparse");
			CPPUNIT_ASSERT(in);
			s2 << in.rdbuf();
			CPPUNIT_ASSERT_EQUAL(s1.str(), s2.str());
			
		}
		{
			// ok
			/*
			AtomType i(getAtom(pm, "i"));
			pm.setFalse(i);
			InjectConstraints injector(pm, p);
			stringstream s1, s2;
			s1 << injector.stream().rdbuf();
			ifstream in("usualcases-i-both.lparse");
			CPPUNIT_ASSERT(in);
			s2 << in.rdbuf();
			CPPUNIT_ASSERT_EQUAL(s1.str(), s2.str());
			*/
		}

	}
	CPPUNIT_TEST_SUITE( ConstraintInjectorTest );
		CPPUNIT_TEST( testEmpty );
		CPPUNIT_TEST( testWithoutConstraint );
		CPPUNIT_TEST( testWithOneTrue );
		CPPUNIT_TEST( testWithOneFalse );
		
	CPPUNIT_TEST_SUITE_END();
};


CPPUNIT_TEST_SUITE_REGISTRATION( ConstraintInjectorTest );


