#! /bin/sh

CC=gcc
SIZES_SOURCE=sizes.c
SIZES_TARGET=sizes
BUILD_SIZES="$CC -pipe $SIZES_SOURCE -o $SIZES_TARGET"

MPI_SOURCE=mpi.c
MPI_TARGET=mpi
BUILD_MPI="$CC -pipe $MPI_SOURCE -o $MPI_TARGET 2>/dev/null 1>/dev/null"

cxx="g++"
cxxflags="-g -Wall -pipe"
build_fork=yes
build_mpi=no


function check_mpi
{
	eval $BUILD_MPI
	if	[ -e mpi ]
	then
		$build_mpi=yes
	fi
}



if [ "`uname -a | grep MINGW32`" ]
then
	defines="-DPT_WINDOWS -DPT_NATIVE_WORD=32 -DPT_X86"
	cxxflags="$cxxflags -m32"
	ldflags="-lwinmm"
	build_fork=no
	build_mpi=no
fi
if [ "`uname -a | grep Linux`" ]
then
	eval $BUILD_SIZES
	defines="-DUNIX -DPT_UNIX -DPT_NATIVE_WORD=`./$SIZES_TARGET`"
	if [ "`uname -a | grep i.86`" -o  "`uname -a | grep x86_64`" ]
	then 
		defines="$defines -DPT_X86"
		cxxflags="$cxxflags -pthread"
	fi
	cxxflags="$cxxflags -m`./$SIZES_TARGET`"
	ldflags="-lrt"
	
	check_mpi
fi
if [ "`uname -a | grep SunOS`" ]
then
	eval $BUILD_SIZES
	defines="-DUNIX -DPT_UNIX -DPT_NATIVE_WORD=`./$SIZES_TARGET`"
	if [ "`uname -a | grep sparc`" ]
	then 
		defines="$defines -DPT_SPARC"
		cxxflags="$cxxflags -pthreads"
	fi
	cxxflags="$cxxflags -m`./$SIZES_TARGET`"
	ldflags="-lrt"
	
	check_mpi
fi

cat prelude

echo "CXX = $cxx"
echo "DEFINES = $defines"
echo "CXXFLAGS = $cxxflags"
echo "LDFLAGS = $ldflags"
echo "INCLUDES = -I\$(LOCAL_PATH) -I\$(LOCAL_PATH)/include"
echo "BUILD_FORK = $build_fork"
echo "BUILD_MPI = $build_mpi"

cat appendix
