/*	$Id: algorithm_callback.h 1728 2005-05-06 08:08:53Z jgressma $
 *
 *  Copyright 2005 University of Potsdam, Germany
 * 
 *	This file is part of Platypus.
 *
 *  Platypus is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  Platypus is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with Platypus; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *
 */

#ifndef ALGORITHM_CALLBACK_H
#define ALGORITHM_CALLBACK_H

#include <iosfwd>
#include <string>

class NopStream;
namespace Platypus
{
	// These interfaces are called upon by the PlatypusAlgorithm 
	// template. 
	class ProgramInterface;
	class PlatypusAlgorithmDistributionCallback
	{
	public:
		virtual ~PlatypusAlgorithmDistributionCallback()
		{}
		// called right after all parameters have been set
		virtual void setup() = 0;
		// called when the core has finished its work
		virtual void teardown() = 0;
		// return true when this particular instance should print its
		// statistics. For forking this returns true for the father
		// process
		virtual bool print() const = 0;
		// actually do printing
		virtual std::ostream& print(std::ostream& os) const = 0;
		// statistic methods
		virtual size_t expanderInitializations() const = 0;
		virtual size_t conflicts() const = 0;
		virtual size_t answerSetsFound() const = 0;
		virtual size_t backtracks() const = 0;
		virtual size_t threadDelegations() const = 0;
		virtual size_t threads() const = 0;
		// return a string that describes the type, e.g. local or fork
		virtual const std::string& type() const = 0;
		// when this method is called the particular instance
		// should initiate a (distributed) shutdown 
		virtual void terminate() = 0;
	};

	inline std::ostream& operator<<(std::ostream& os, const PlatypusAlgorithmDistributionCallback& traits)
	{
		return traits.print(os);
	}

	class PlatypusAlgorithmCoreCallback
	{
	public:
		virtual ~PlatypusAlgorithmCoreCallback()
		{}
		// return a string that describes the type, e.g. single-threaded or multi-threaded
		virtual const std::string& type() const = 0;
		// start the core algorithm
		virtual void run() = 0;
	};
}

#endif
