/*	$Id: builder.cpp 1728 2005-05-06 08:08:53Z jgressma $
 *
 *  Copyright 2005 University of Potsdam, Germany
 * 
 *	This file is part of Platypus.
 *
 *  Platypus is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  Platypus is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with Platypus; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *
 */

#include <memory>
#include <iostream>
#include <cassert>
#include <nop_stream.h>
#include <platypus/program_base.h>
#include <platypus/types_factory.h>
#include <platypus/distribution_base.h>
#include <platypus/core_base.h>
#include <platypus/algorithm/algorithm.h>
#include <platypus/builder/options.h>
#include <platypus/builder/options_builder.h>
#include <platypus/builder/builder_factory_registration.h>
#include <platypus/builder/builder.h>

using namespace std;

namespace Platypus
{
	PlatypusBuilder::~PlatypusBuilder()
	{}
	PlatypusBuilder::PlatypusBuilder()
		:	stream_(new NopStream(&cout))
	{}
	std::string PlatypusBuilder::usage() const
	{
		return optionsBuilder_.usage();
	}
	void PlatypusBuilder::registerFactories()
	{
		auto_ptr<FactoryRegistrationStrategy> strategy(OSSpecificRegistrationFactory::create());
		strategy->registerWithFactories();
	}

	void PlatypusBuilder::buildDistribution(int& argc, char** argv)
	{
		distribution_.reset(
			PlatypusTypesFactory::instance().distributionFactory().create(options_->mode()));
		BuilderDistributionCallback* bdc = distribution_.get();

		bdc->processCommandLine(argc, argv);
		bdc->output(*stream_);
		bdc->options(*options_);	
		bdc->program(*program_);
	}
	void PlatypusBuilder::buildCore()
	{
		core_.reset(
			PlatypusTypesFactory::instance().coreFactory().create(options_->core()));
		BuilderCoreCallback* bcc = core_.get();

		bcc->distribution(*distribution_);
		bcc->factory(PlatypusTypesFactory::instance());
		bcc->options(*options_);
		bcc->output(*stream_);
		bcc->program(*program_);
	}
	PlatypusAlgorithm* PlatypusBuilder::build(int& argc, char** argv)
	{
		options_.reset(optionsBuilder_.build(argc, argv));
		if(options_->wantHelpOnOptions())
			return 0;

		if(options_->debugPrinting())
			stream_->enable();

		program_.reset(
			PlatypusTypesFactory::instance().programFactory().create(options_->expander()));

		buildDistribution(argc, argv);
		buildCore();
		
		return new PlatypusAlgorithm(stream_, program_, options_, core_, distribution_);
	}
}

