/*	$Id: options.cpp 1728 2005-05-06 08:08:53Z jgressma $
 *
 *  Copyright 2005 University of Potsdam, Germany
 * 
 *	This file is part of Platypus.
 *
 *  Platypus is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  Platypus is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with Platypus; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *
 */

#include <program_options/program_options.h>
#include <program_options/value.h>
#include <platypus/builder/options.h>
#include <platypus/types/chooser.h>

using namespace std;

namespace Platypus
{
	/////////////////////////////////////////////////////////////////////////
	// PlatypusOptions
	/////////////////////////////////////////////////////////////////////////
	PlatypusOptions::PlatypusOptions()
		:	requestedAnswerSets_(0)
		,	percentage_(20)
		,	threads_(2)
		,	debugPrinting_(false)
		,	wantHelpOnOptions_(false)
		,	silent_(false)
		,	manualChoices_(false)
	{}
	void PlatypusOptions::options(const ProgramOptions::OptionValues& values)
	{
		// we are safe here, the types have already been checked so no expceptions
		// are expected while extracting the data
		localChoicePolicy_ = ProgramOptions::option_as<string>(values, "localChoicePolicy");
		if(localChoicePolicy_ != CHOICE_POLICY_EXPANDER)
			manualChoices_ = true;
		dcChoicePolicy_ = ProgramOptions::option_as<string>(values, "delegatableChoicePolicy");
		if(values.count("file"))
			filename_ = ProgramOptions::option_as<string>(values, "file");
		requestedAnswerSets_ = ProgramOptions::option_as<int>(values, "answerSets");
		debugPrinting_ = ProgramOptions::option_as<bool>(values, "debug-prints");
		wantHelpOnOptions_ = ProgramOptions::option_as<bool>(values, "help");
		percentage_ = ProgramOptions::option_as<int>(values, "delegationThreshold");
		silent_ = ProgramOptions::option_as<bool>(values, "silent");
		expander_ = ProgramOptions::option_as<string>(values, "expander");
		core_ = ProgramOptions::option_as<string>(values, "core");
		threads_ = ProgramOptions::option_as<int>(values, "threads");
		mode_ = ProgramOptions::option_as<string>(values, "mode");

		probing_ = ProgramOptions::option_as<bool>(values, "probing");
		probingInitialCutoff_ = static_cast<unsigned>(ProgramOptions::option_as<int>(values, "probing-initial-cutoff"));
		probingSteps_ = static_cast<unsigned>(ProgramOptions::option_as<int>(values, "probing-steps"));
	}	
}

