/*	$Id: smodels_expander.cpp 1728 2005-05-06 08:08:53Z jgressma $
 *
 *  Copyright 2005 University of Potsdam, Germany
 * 
 *	This file is part of Platypus.
 *
 *  Platypus is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  Platypus is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with Platypus; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *
 */

#include <cassert>
#include <string>
#include <platypus/program_base.h>
#include <platypus/types/atom.h>
#include <platypus/types/exceptions.h>
#include <platypus/types/expander_strategies.h>
#include <platypus/smodels/smodels_expander.h>
#include <platypus/smodels/smodels_program.h>
#include <platypus/smodels/smodels_expander_impl.h>

using namespace std;

namespace Platypus
{
	///////////////////////////////////////////////////////////
	// SmodelsExpander
	///////////////////////////////////////////////////////////
	SmodelsExpander::~SmodelsExpander()
	{
		if(pimpl_)
			pimpl_->~SmodelsExpanderImpl();
	}
	SmodelsExpander::SmodelsExpander(const ProgramInterface& program, const DelegatableChoice& dc)
		:	program_(dynamic_cast<const SmodelsEnhancedProgram*>(&program))
		,	pimpl_(0)
		,	raw_(new char[sizeof(SmodelsExpanderImpl)])
	{
		if(!program_)
			throw TypeError("Passed non SmodelsEnhancedProgram to SmodelsExpander c'tor!");
		createStrategy(this, dc);		
		reinitialize(dc);
	}

	bool SmodelsExpander::hasUnknown() const
	{
		return pimpl_->hasUnknown();
	}
	bool SmodelsExpander::hasConflict() const
	{
		return pimpl_->hasConflict();
	}
	void SmodelsExpander::strategyExpand(const Choice& choice)
	{
		//pimpl_->makeChoice(program_->idToName(choice.id()), choice.isPositive());
		pimpl_->makeChoice(choice.id(), choice.isPositive());
	}
	void SmodelsExpander::strategyReinitialize(const DelegatableChoice& dc)
	{
		//pimpl_.reset(new SmodelsExpanderImpl(*program_, dc));
		if(pimpl_)
		{
			SmodelsExpanderImpl* temp = pimpl_;
			pimpl_ = 0;
			temp->~SmodelsExpanderImpl();
		}
		pimpl_ = new (raw_.get()) SmodelsExpanderImpl(*program_, dc);
	}
	void SmodelsExpander::strategyBacktrackTo(const Choice& choice)
	{
		//pimpl_->backtrackTo(program_->idToName(choice.id()));
		pimpl_->backtrackTo(choice.id());
	}
	Choice SmodelsExpander::strategyGetChoice()
	{
		return pimpl_->getChoice();
	}
	PossibleChoices SmodelsExpander::possibleChoices() const
	{
		return pimpl_->possibleChoices();
	}

	PartialAssignment SmodelsExpander::partialAssignment() const
	{
		return pimpl_->partialAssignment();
	}

	size_t SmodelsExpander::unknownAtoms() const
	{
		return pimpl_->unknownAtoms();
	}
	Expander* SmodelsExpander::create(const ProgramInterface& program, const DelegatableChoice& dc)
	{
		return new SmodelsExpander(program, dc);
	}
}
