/*	$Id: smodels_expander_impl.h 1728 2005-05-06 08:08:53Z jgressma $
 *
 *  Copyright 2005 University of Potsdam, Germany
 * 
 *	This file is part of Platypus.
 *
 *  Platypus is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  Platypus is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with Platypus; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *
 */

#ifndef SMODELS_EXPANDER_IMPL_H
#define SMODELS_EXPANDER_IMPL_H

#include <string>
#include <vector>
#include <memory>
#include <platypus/smodels/smodels_wrapper.h>
#include <platypus/types/partial_assignment.h>
#include <platypus/types/choice.h>


class Api;
class Atom;
class Node;
class Smodels;
namespace Platypus
{
	class SmodelsEnhancedProgram;
	class ProgramInterface;
	class SmodelsExpanderImpl
	{
	public:
		~SmodelsExpanderImpl();
		SmodelsExpanderImpl(const SmodelsEnhancedProgram& program, const DelegatableChoice& dc);
	
		void makeChoice(const std::string& name, bool setTrue);
		void backtrackTo(const std::string& name);

		void makeChoice(AtomId id, bool setTrue);
		void backtrackTo(AtomId id);
	
		bool hasConflict() const;
		bool hasUnknown() const;

		PartialAssignment partialAssignment() const;
		PossibleChoices possibleChoices() const;
		size_t unknownAtoms() const;
		Choice getChoice();
	private:
		SmodelsExpanderImpl();
		typedef SmodelsAtomsIterator iterator;
		typedef SmodelsAtomsConstIterator const_iterator;
		const_iterator begin() const;
		const_iterator end() const;
		void addComputeStatements(SmodelsHolder* holder, const DelegatableChoice& dc, const ProgramInterface& program);
		void finalize(Api& api_);
		void finalize(SmodelsHolder* holder);
		void finalizeCommon();
		void findSmodelsChoice();
		void manualExpand();
		void backtrackAll();
		void makeChoiceCommon();
		void backtrackCommon(::Atom* atom);
		::Atom* resolveAtom(AtomId id) const;
	private:
		typedef std::vector< ::Atom* > Dictionary;
	private:
		const SmodelsEnhancedProgram* program_;
		Dictionary dictionary_;
		std::auto_ptr<Smodels> smodels_;
		std::string choice_;
		bool positive_;
	};
}

#endif
