/*	$Id: smodels_program.cpp 1728 2005-05-06 08:08:53Z jgressma $
 *
 *  Copyright 2005 University of Potsdam, Germany
 * 
 *	This file is part of Platypus.
 *
 *  Platypus is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  Platypus is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with Platypus; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *
 */

#include <cassert>
#include <array_istream.h>
#include <platypus/smodels/smodels_program.h>
#include <platypus/smodels/smodels_wrapper.h>

using namespace std;

namespace Platypus
{
	SmodelsEnhancedProgram::~SmodelsEnhancedProgram()
	{
		// quiets compiler warnings about SmodelsHolderFactory
		// having an incomplete type
	}
	SmodelsEnhancedProgram::SmodelsEnhancedProgram()
	{
		init();
	}
	void SmodelsEnhancedProgram::init()
	{
		array_istream s(Program::lparse());
		factory_.reset(new SmodelsHolderFactory(s));
	}
	void SmodelsEnhancedProgram::setup(const std::string& input)
	{
		Program::setup(input);
		init();
	}
	void SmodelsEnhancedProgram::setup(std::istream& input)
	{
		Program::setup(input);
		init();
	}
	SmodelsHolder* SmodelsEnhancedProgram::holder() const
	{
		return factory_->create();
	}
	ProgramInterface* SmodelsEnhancedProgram::create()
	{
		return new SmodelsEnhancedProgram;
	}
}
