/*	$Id: smodels_program.h 1728 2005-05-06 08:08:53Z jgressma $
 *
 *  Copyright 2005 University of Potsdam, Germany
 * 
 *	This file is part of Platypus.
 *
 *  Platypus is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  Platypus is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with Platypus; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *
 */

#ifndef PLATYPUS_SMODELS_PROGRAM_IMPL_H
#define PLATYPUS_SMODELS_PROGRAM_IMPL_H

#include <iosfwd>
#include <string>
#include <memory>
#include <platypus/types/program.h>


namespace Platypus
{
	// Unfortunately we cannot build a program-wide
	// Platypus::AtomId to Smodels ::Atom* or Smodels atom[] index
	// translation -> first part is because each expander has
	// its own set of atoms and hence atom addresses -> pointers!
	// second part is because the content of the atom[] changes
	// permanently as smodels derives new atoms.
	class SmodelsHolder;
	class SmodelsHolderFactory;
	class SmodelsEnhancedProgram : public Program
	{
	public:
		SmodelsEnhancedProgram();
		~SmodelsEnhancedProgram();
		static ProgramInterface* create();
		void setup(const std::string& input);
		void setup(std::istream& input);
		SmodelsHolder* holder() const;
	private:
		void init();
	private:
		std::auto_ptr<SmodelsHolderFactory> factory_;		
	};
}

#endif
