/*	$Id: smodels_wrapper.cpp 1728 2005-05-06 08:08:53Z jgressma $
 *
 *  Copyright 2005 University of Potsdam, Germany
 * 
 *	This file is part of Platypus.
 *
 *  Platypus is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  Platypus is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with Platypus; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *
 */

#include <iostream>
#include <cassert>
#include <algorithm>
#include <platypus/smodels/smodels_wrapper.h>
#include <smodels/smodels.h>
#include <smodels/api.h>
#include <smodels/read.h>
#include <smodels/atomrule.h>

using namespace std;

namespace Platypus
{
	SmodelsHolder::~SmodelsHolder()
	{}
	SmodelsHolder::SmodelsHolder(const Api* api)
		:	smodels_(new Smodels)
		,	api_(new Api(&smodels_->program))
	{
		//api_->remember();
		if(!api)
			throw SmodelsWrapperError("Api pointer is NULL!");
		if(api->done_)
			throw SmodelsWrapperError("Api::done() has been called!");
		api_->copy(api);
	}
	Smodels* SmodelsHolder::finalize() 
	{
		if(!good())
			throw SmodelsWrapperError("Already called finalize!");
		
		api_->done();
		api_.reset();
		smodels_->init();
		return smodels_.release();
	}
	SmodelsHolder::const_iterator SmodelsHolder::begin() const { return const_iterator(smodels_->program.atoms.head()); }
	SmodelsHolder::const_iterator SmodelsHolder::end() const { return const_iterator(); }
	bool SmodelsHolder::addComputeStatement(const_iterator it, bool setTrue)
	{
		if(!good())
			throw SmodelsWrapperError("Already called finalize!");

		assert(std::distance(it, end()) > 0);

		api_->set_compute(const_cast< ::Atom* >(&*it), setTrue);
		return true;
	}
	const ::Smodels* SmodelsHolder::smodels() const { return smodels_.get(); }
	::Api* SmodelsHolder::api() { return api_.get(); }


	SmodelsHolderFactory::~SmodelsHolderFactory()
	{}
	SmodelsHolderFactory::SmodelsHolderFactory(std::istream& is)
		:	smodels_(new Smodels)
		,	api_(new Api(&smodels_->program))
	{
		Read reader(&smodels_->program, api_.get());
		if(reader.read(is))
			throw SmodelsWrapperError("Error in input!");
	}
	SmodelsHolderFactory::SmodelsHolderFactory(const Api* api)
		:	smodels_(new Smodels)
		,	api_(new Api(&smodels_->program))
	{
		if(api->done_)
			throw SmodelsWrapperError("Api::done() has been called!");
		api_->copy(api);
	}
	SmodelsHolder* SmodelsHolderFactory::create() const
	{
		return new SmodelsHolder(api_.get());
	}
	

}
