/*	$Id: choice_feeder.cpp 1728 2005-05-06 08:08:53Z jgressma $
 *
 *  Copyright 2005 University of Potsdam, Germany
 * 
 *	This file is part of Platypus.
 *
 *  Platypus is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  Platypus is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with Platypus; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *
 */

#include <cassert>
#include <iostream>
#include <platypus/types/expander.h>
#include <platypus/types/choice_feeder.h>

using namespace std;

namespace Platypus
{
	ChoiceFeeder::ChoiceFeeder(const DelegatableChoice& choices_to_feed)
		:	choicesToFeed_(choices_to_feed)
	{}
	ChoiceFeeder::ChoiceFeeder(DelegatableChoice& choices_to_feed)
	{
		choicesToFeed_.swap(choices_to_feed);
	}
	void ChoiceFeeder::feed(Expander& expander) const
	{
		// It is absolutely possible that after initializing an
		// expander with a given core we already have a conflict 
		// or an answer set
		if(!expander.hasConflict() && expander.hasUnknown())
		{
			for(DelegatableChoice::const_iterator it = choicesToFeed_.begin();
				it != choicesToFeed_.end(); ++it)
			{
				// The assumption is: If we reinitialize an expander using a 
				// set of choices the expander previously made, then no
				// error must occur!
				expander.expand(*it);
				assert(!expander.hasConflict());
				assert(expander.hasUnknown());
				
			}
		}
	}
}

