/*	$Id: choices_to_do.h 1728 2005-05-06 08:08:53Z jgressma $
 *
 *  Copyright 2005 University of Potsdam, Germany
 * 
 *	This file is part of Platypus.
 *
 *  Platypus is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  Platypus is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with Platypus; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *
 */

#ifndef PLATYPUS_CHOICESTODO_IMPL_H
#define PLATYPUS_CHOICESTODO_IMPL_H

#include <iosfwd>
#include <vector>
#include <memory>
#include <platypus/types/choice.h>
#include <platypus/types/choice_feeder.h>

namespace Platypus
{
	struct ChoiceInfo
	{
		Choice choice_;
		bool toggled_, core_, delegated_;
		ChoiceInfo(const Choice& choice, bool toggled = false, bool core = false)
			:	choice_(choice)
			,	toggled_(toggled)
			,	core_(core)
			,	delegated_(false)
		{}
	};
	
	// the "stack" to use with DelegatableChoice policy classes
	typedef std::vector<ChoiceInfo> ChoicesDone;

	// Base class for all DelegatableChoice policies
	class DCPolicy
	{
	public:
		typedef ChoicesDone::const_iterator const_iterator;
		virtual ~DCPolicy()
		{}
		virtual const_iterator choose(const_iterator begin, const_iterator end) = 0;
		virtual DCPolicy* clone() const = 0;
	protected:
		bool possibleChoice(const ChoiceInfo& info) const;
	};

	class ChoicesToDo
	{
	public:
		typedef ChoicesDone::iterator iterator;
		typedef ChoicesDone::const_iterator const_iterator;
		typedef ChoicesDone::const_reverse_iterator const_reverse_iterator;
		typedef DCPolicy DelegatableChoicePolicyType;
		ChoicesToDo(const DelegatableChoice& dc = DelegatableChoice());
		
		// sets the current DelegatableChoicePolicy object
		// create copy
		void setDelegatableChoicePolicy(const DelegatableChoicePolicyType& policy);
		// accquire ownership
		void setDelegatableChoicePolicy(DelegatableChoicePolicyType* policy);

		// adds a choice to the "choices todo" collection
		void add(const Choice& choice);
		
		// returns true whenever there are choices stored, false otherwise
		bool hasChoice() const;
		
		// returns the next (local choice to be change using the 
		// builtin policy (chronological backtracking)
		Choice nextChoice();	

		// return the history of the last choice including the choice itself
		DelegatableChoice choiceHistory() const;
		// returns the next Choice that will be shippable ;-)
		DelegatableChoice nextDelegatableChoice();	

		DelegatableChoice core();
		ChoiceFeeder feeder() const;
		ChoicesToDo* split();
		void reinitialize(const DelegatableChoice& dc);
		size_t coreSize() const;
	private:
		void popUsed();
		void findLatestChoice();
		void extendCore();
		static bool flippable(const ChoiceInfo& ci);
		DelegatableChoice createDelegatableChoice(const const_iterator chosen);
		friend std::ostream& operator<<(std::ostream& os, const ChoicesToDo& ctd);
	private:
		ChoicesDone choiceHistory_;
		std::auto_ptr<DelegatableChoicePolicyType> policy_;
		int latest_;
		size_t coreSize_;
	};

	std::ostream& operator<<(std::ostream& os, const ChoicesToDo& ctd);
}

#endif
