/*	$Id: delegatable_choice_policy.cpp 1728 2005-05-06 08:08:53Z jgressma $
 *
 *  Copyright 2005 University of Potsdam, Germany
 * 
 *	This file is part of Platypus.
 *
 *  Platypus is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  Platypus is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with Platypus; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *
 */

#include <vector>
#include <cassert>
#include <iterator>
#include <platypus/types/delegatable_choice_policy.h>

using namespace std;

namespace Platypus
{
	///////////////////////////////////////////////////////////
	// ChooseRandomPolicy
	///////////////////////////////////////////////////////////
	ChooseRandomPolicy::ChooseRandomPolicy()
		:	rng_(static_cast<unsigned long>(PortableThreads::PTime().stamp()))
	{}
	ChooseRandomPolicy::const_iterator ChooseRandomPolicy::choose(const_iterator begin, const_iterator end)
	{
		typedef vector<size_t> IndexList;
		IndexList candidates;
		size_t index = 0;
		// find all the candidates in the stack that make acceptable
		// delegatable choices
		for(const_iterator it = begin;
			it != end; ++it, ++index)
		{
			if(possibleChoice(*it))
				candidates.push_back(index);
		}

		// This should have been checked in ChoicesToDo!
		assert(!candidates.empty());

		const size_t chosen = rng_.urand() % candidates.size();

		advance(begin, chosen);
		return begin;
	}
	DCPolicy* ChooseRandomPolicy::clone() const
	{
		return new ChooseRandomPolicy(*this);
	}

	DCPolicy* ChooseRandomPolicy::create() { return new ChooseRandomPolicy(); }

	///////////////////////////////////////////////////////////
	// ChooseEarliestPolicy
	///////////////////////////////////////////////////////////	
	ChooseEarliestPolicy::const_iterator ChooseEarliestPolicy::choose(const_iterator begin, const_iterator end)
	{
		for(const_iterator it = begin; it != end; ++it)
		{
			if(possibleChoice(*it))
				return it;
		}
		return end;
	}
	DCPolicy* ChooseEarliestPolicy::clone() const
	{
		return new ChooseEarliestPolicy(*this);
	}
	DCPolicy* ChooseEarliestPolicy::create() { return new ChooseEarliestPolicy(); }
	
	
	
}
