/*	$Id: expander_strategies.h 1728 2005-05-06 08:08:53Z jgressma $
 *
 *  Copyright 2005 University of Potsdam, Germany
 * 
 *	This file is part of Platypus.
 *
 *  Platypus is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  Platypus is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with Platypus; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *
 */

#ifndef PLATYPUS_EXPANDER_STRATEGIES_IMPL_H
#define PLATYPUS_EXPANDER_STRATEGIES_IMPL_H

#include <platypus/types/choice.h>

namespace Platypus
{
	class ChoicePolicy;
	class BacktrackCallback;
	class ChooseCallback;

	// Strategy pattern to handle backtracking and choosing uniformly
	class BacktrackStrategy
	{
	public:
		virtual ~BacktrackStrategy()
		{}
		virtual void expand(const Choice&) = 0;
		virtual void backtrack(const Choice&) = 0;
		virtual void reinitialize(const DelegatableChoice&) = 0;
		virtual bool nativeBacktracker() const = 0;
	};

	class NativeBacktracker : public BacktrackStrategy
	{
	public:
		NativeBacktracker(BacktrackCallback& expander);
		void expand(const Choice& choice);
		void backtrack(const Choice& choice);
		void reinitialize(const DelegatableChoice& dc);
		bool nativeBacktracker() const { return true; }
	private:
		NativeBacktracker();
	private:
		BacktrackCallback* expander_;
	};

	class ManualBacktracker : public BacktrackStrategy
	{
	public:
		ManualBacktracker(BacktrackCallback& expander, const DelegatableChoice& dc);
		void expand(const Choice& choice);
		void backtrack(const Choice& choice);
		void reinitialize(const DelegatableChoice& dc);
		bool nativeBacktracker() const { return false; }
	private:
		ManualBacktracker();
	private:
		BacktrackCallback* expander_;
		DelegatableChoice stack_;
	};

	class ChooseStrategy
	{
	public:
		virtual ~ChooseStrategy()
		{}
		virtual Choice choose() = 0;
		virtual void setPolicy(ChoicePolicy&) = 0;
		virtual bool nativeChooser() const = 0;
	};

	class NativeChooser : public ChooseStrategy
	{
	public:
		NativeChooser(ChooseCallback& chooser);
		Choice choose();
		void setPolicy(ChoicePolicy& policy);
		bool nativeChooser() const { return true; }
	private:
		NativeChooser();
	private:
		ChooseCallback* chooser_;
	};

	class ManualChooser : public ChooseStrategy
	{
	public:
		ManualChooser(ChooseCallback& chooser);
		Choice choose();
		void setPolicy(ChoicePolicy& policy);
		bool nativeChooser() const { return false; }
	private:
		ManualChooser();
	private:
		ChooseCallback* chooser_;
		ChoicePolicy* policy_;
	};
}

#endif
