/*	$Id: inject_constraints.cpp 1728 2005-05-06 08:08:53Z jgressma $
 *
 *  Copyright 2005 University of Potsdam, Germany
 * 
 *	This file is part of Platypus.
 *
 *  Platypus is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  Platypus is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with Platypus; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *
 */

#include <platypus/types/inject_constraints.h>
#include <platypus/program_base.h>

using namespace std;

namespace Platypus
{
	///////////////////////////////////////////////////////////
	// InjectConstraints
	///////////////////////////////////////////////////////////
	std::string InjectConstraints::formatLparse(const DelegatableChoice& dc, const ProgramInterface& program)
	{
		typedef std::vector<AtomId> IdList;
		IdList positive, negative;
		// store set of positive and negative choices as constraints
		for(DelegatableChoice::const_iterator it = dc.begin();
			it != dc.end(); ++it)
		{
			if(it->isPositive())
				positive.push_back(it->id());
			else
				negative.push_back(it->id());
		}
						
		string output, line;

		stringstream s(program.lparse());
		bool readingBPlus = false;
		bool readingBMinus = false;
		while(getline(s, line))
		{
			if(line.empty())
				continue;

			if(line == "B+")
			{
				output += "B+\n";	
				readingBPlus = true;
				continue;
			}

			if(readingBPlus)
			{
				if(line == "0")
				{
					readingBPlus = false;
					readingBMinus = true;
					
					for(IdList::const_iterator it = positive.begin();
						it != positive.end(); ++it)
					{
						ostringstream id;
						id << *it << '\n';
						output += id.str();
					}
					
					output += "0\n";
					continue;
				}					
				
			}

			if(readingBMinus)
			{
				if(line == "0")
				{
					readingBMinus = false;

					for(IdList::const_iterator it = negative.begin();
						it != negative.end(); ++it)
					{
						ostringstream id;
						id << *it << '\n';
						output += id.str();
					}
					
					output += "0\n";
					continue;
				}					
				
			}

			output += line;
			output += '\n';
		}
		return output;
	}

	InjectConstraints::InjectConstraints(const DelegatableChoice& dc, const ProgramInterface& program)
		:	stream_(formatLparse(dc, program))
	{}
	std::stringstream& InjectConstraints::stream() 
	{
		return stream_;
	}

}
