/*	$Id: probing_manager.h 1728 2005-05-06 08:08:53Z jgressma $
 *
 *  Copyright 2005 University of Potsdam, Germany
 * 
 *	This file is part of Platypus.
 *
 *  Platypus is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  Platypus is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with Platypus; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *
 */

#ifndef PROBING_MANAGER_H
#define PROBING_MANAGER_H

#include <vector>
#include <smartpointer.h>
#include <portablethreads/utility.h>

namespace Platypus
{
	class ChoicesToDo;
	class ProbingManager
	{
	public:
		ProbingManager(unsigned initial, unsigned probes, bool enabled = false);
		// add object and split using the earliest not
		// fixed choice
		// takes ownership of object passed
		void add(ChoicesToDo* ctd);
		ChoicesToDo* select();
		bool restart();
		void markBacktrack();
		void markAnswerSet();
		bool exhausted() const;
	private:
		typedef std::vector< StackPtr<ChoicesToDo> > Branches;
	private:
		Branches branches_;
		PortableThreads::PRandom rng_;
		unsigned backtracksBeforeRestart_;
		unsigned backtrackCounter_;
		unsigned probes_;
		unsigned probeCounter_;
		unsigned bestN_;
		/*
		unsigned maxSize_;
		
		*/
		bool enabled_;
		
		
		
	};
}

#endif
