/*	$Id: program.h 1728 2005-05-06 08:08:53Z jgressma $
 *
 *  Copyright 2005 University of Potsdam, Germany
 * 
 *	This file is part of Platypus.
 *
 *  Platypus is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  Platypus is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with Platypus; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *
 */

#ifndef PLATYPUS_PROGRAM_IMPL_H
#define PLATYPUS_PROGRAM_IMPL_H

#include <string>
#include <iosfwd>
#include <vector>
#include <map>
#include <platypus/program_base.h>

namespace Platypus
{
	const char* const EMPTY_PROGRAM = "0\n0\nB+\n0\nB-\n0\n1\n";

	class Program : public virtual ProgramInterface
	{
	public:
		typedef std::vector<std::string> Id2Name;
		typedef std::map<std::string, AtomId> Name2Id;

		Program();
		static ProgramInterface* create();
		virtual void setup(const std::string& input);
		virtual void setup(std::istream& input);

		// returns the associated name for an atom
		const std::string& idToName(AtomId id) const;
		
		// returns the id associated with an atom name
		// NOTE: 	Names MUST be returned for all atoms, wether
		// 			they have a "name" (like a, p(v4), ...) or not.	
		AtomId nameToId(const std::string& name) const;
		
		// returns the collection of atoms of the logic program
		const CollectionType& atoms() const;
		
		// Returns the definite number of atoms in the logic program.
		// For instance the logic program
		// d :- {c} 1.
		// c.
		//
		// after being preprocessed by lparse contains FOUR atoms.
		size_t numberOfAtoms() const;
		size_t numberOfRules() const;
		
		// returns true if the atom had a name in the original (textual program), false otherwise.
		bool hasDisplayName(AtomId id) const;	
		
		// returns an lparse representation of the preprocessed program.
		const std::string& lparse() const;
	private:
		void setupMappings(std::istream& is);
	private:
		Id2Name ids_;
		Name2Id names_;
		CollectionType atoms_;
		std::string lparse_;
		size_t rules_;
	};
}

#endif
