/*  Copyright (c) January 2005 Jean Gressmann (jsg@rz.uni-potsdam.de)
 *
 *  This is free software; you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License as published by
 *	the Free Software Foundation; either version 2 of the License, or
 *	(at your option) any later version. 
 * 
 *	This file is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.
 *
 *	You should have received a copy of the GNU General Public License
 *	along with this file; if not, write to the Free Software
 *	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef ARCH_COMMON_H
#define ARCH_COMMON_H

PT_NAMESPACE_BEGIN
// Interger type definitions based on size
namespace PTPrivate
{
	template<unsigned>
	struct PTSizeToType_;

	template<>
	struct PTSizeToType_<1>
	{
		typedef int8 int_type;
		typedef uint8 uint_type;
	};

	template<>
	struct PTSizeToType_<2>
	{
		typedef int16 int_type;
		typedef uint16 uint_type;
	};

	template<>
	struct PTSizeToType_<4>
	{
		typedef int32 int_type;
		typedef uint32 uint_type;
	};

	template<>
	struct PTSizeToType_<8>
	{
		typedef int64 int_type;
		typedef uint64 uint_type;
	};
}

typedef PTPrivate::PTSizeToType_<sizeof(void*)>::int_type pt_pointer_type;
typedef PTPrivate::PTSizeToType_<sizeof(unsigned long)>::int_type pt_int_type;
typedef PTPrivate::PTSizeToType_<sizeof(unsigned long)>::uint_type pt_uint_type;

PT_NAMESPACE_END

#endif
