/*  Copyright (c) January 2005 Jean Gressmann (jsg@rz.uni-potsdam.de)
 *
 *  This is free software; you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License as published by
 *	the Free Software Foundation; either version 2 of the License, or
 *	(at your option) any later version. 
 * 
 *	This file is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.
 *
 *	You should have received a copy of the GNU General Public License
 *	along with this file; if not, write to the Free Software
 *	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef X86_32_WIN32_MINGW_H
#define X86_32_WIN32_MINGW_H

PT_NAMESPACE_BEGIN
typedef signed char int8;
typedef unsigned char uint8;
typedef short int16;
typedef unsigned short uint16;
typedef int int32;
typedef unsigned int uint32;
typedef long long int64;
typedef unsigned long long uint64;

inline void pt_barrier()
{
	__asm__ __volatile__("mfence": : :"memory");
}

inline int32 pt_rol(int32 value, unsigned char shift = 1)
{
	__asm__ (
		"roll %1, %0"
		:"=r"(value)
		:"c"(shift), "0"(value)
		:"cc"
	);
	
	return value;
}
inline int32 pt_ror(int32 value, unsigned char shift = 1)
{
	__asm__ (
		"rorl %1, %0"
		:"=r"(value)
		:"c"(shift), "0"(value)
		:"cc"
	);
	
	return value;
}

PT_NAMESPACE_END

#include <portablethreads/arch/x86-32-win32-common.h>
#include <portablethreads/arch/native-pointer-cas.h>

#endif
