/*  Copyright (c) January 2005 Jean Gressmann (jsg@rz.uni-potsdam.de)
 *
 *  This is free software; you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License as published by
 *	the Free Software Foundation; either version 2 of the License, or
 *	(at your option) any later version. 
 * 
 *	This file is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.
 *
 *	You should have received a copy of the GNU General Public License
 *	along with this file; if not, write to the Free Software
 *	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef X86_32_WIN32_MSVC_H
#define X86_32_WIN32_MSVC_H

#pragma warning(disable:4786) //'identifier' : identifier was truncated to 'number' characters in the debug information
#pragma warning(disable:4503)

PT_NAMESPACE_BEGIN
typedef signed char int8;
typedef unsigned char uint8;
typedef short int16;
typedef unsigned short uint16;
typedef int int32;
typedef unsigned int uint32;
typedef __int64 int64;
typedef unsigned __int64 uint64;

inline void pt_barrier()
{
	__asm
	{
		pause
	}
}

inline bool __cdecl pt_atomic_cas(volatile int64* inMemory, int64 nv, int64 ov)
{
	/*
	If you use the __fastcall calling convention, the compiler passes function arguments in 
	registers instead of on the stack. This can create problems in functions with __asm blocks 
	because a function has no way to tell which parameter is in which register. If the function 
	happens to receive a parameter in EAX and immediately stores something else in EAX, the original
	parameter is lost. In addition, you must preserve the ECX register in any function declared 
	with __fastcall.

	To avoid such register conflicts, don't use the __fastcall convention for functions that 
	contain an __asm block. If you specify the __fastcall convention globally with the /Gr compiler
	option, declare every function containing an __asm block with __cdecl or __stdcall. 
	(The __cdecl attribute tells the compiler to use the C calling convention for that function.) 
	If you are not compiling with /Gr, avoid declaring the function with the __fastcall attribute.

	When using __asm to write assembly language in C/C++ functions, you don't need
	to preserve the EAX, EBX, ECX, EDX, ESI, or EDI registers.
	(from MSDN)
	*/
	const int32 oldLow = static_cast<int32>(ov);
	const int32 oldHigh = static_cast<int32>(ov >> 32);
	const int32 newLow = static_cast<int32>(nv);
	const int32 newHigh = static_cast<int32>(nv >> 32);
	bool yes;
	__asm
	{
		mov eax, oldLow
		mov edx, oldHigh
		mov ebx, newLow
		mov ecx, newHigh
		mov edi, inMemory
		lock cmpxchg8b [edi]
		sete yes
	}
	return yes;
}

inline int32 __cdecl pt_rol(int32 value, unsigned char shift = 1)
{
	__asm
	{
		mov eax, value
		mov cl, shift
		rol eax, cl
		mov value, eax
	}
	return value;
}
inline int32 __cdecl pt_ror(int32 value, unsigned char shift = 1)
{
	__asm
	{
		mov eax, value
		mov cl, shift
		ror eax, cl
		mov value, eax
	}
	return value;
}



PT_NAMESPACE_END

#include <portablethreads/arch/x86-32-win32-common.h>
#include <portablethreads/arch/native-pointer-cas.h>

#endif
