/*  Copyright (c) January 2005 Jean Gressmann (jsg@rz.uni-potsdam.de)
 *
 *  This is free software; you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License as published by
 *	the Free Software Foundation; either version 2 of the License, or
 *	(at your option) any later version. 
 * 
 *	This file is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.
 *
 *	You should have received a copy of the GNU General Public License
 *	along with this file; if not, write to the Free Software
 *	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
 
#ifndef PT_ATOMIC_NUMBER_H
#define PT_ATOMIC_NUMBER_H
#include <portablethreads/config.h>

PT_NAMESPACE_BEGIN
class PAtomicNumber
{
public:
	typedef pt_int_type int_type;
	// Constructs an object with an initial value of v
	PAtomicNumber(int_type v = 0)
		:	value_(v)
	{}
	inline int_type dec(int_type value = 1)
	{
		return pt_atomic_sub(&value_, value);
	}
	inline int_type inc(int_type value = 1)
	{
		return pt_atomic_add(&value_, value);
	}
	
	// mere convenience
	inline int_type operator--()
	{
		return dec();
	}	
	inline int_type operator--(int)
	{
		return dec() + 1;
	}	
	inline int_type operator++()
	{
		return inc();
	}

	inline int_type operator++(int)
	{
		return inc() - 1;
	}
	inline int_type get() const
	{
		return value_;
	}
	inline bool swap(int_type newValue, int_type oldValue)
	{
		return pt_atomic_cas(&value_, newValue, oldValue);
	}
	inline PAtomicNumber& operator=(int_type value)
	{
		pt_atomic_set(&value_, value);
		return *this;
	}
private:
	volatile int_type value_;
};

PT_NAMESPACE_END

#endif
