/*  Copyright (c) January 2005 Jean Gressmann (jsg@rz.uni-potsdam.de)
 *
 *  This is free software; you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License as published by
 *	the Free Software Foundation; either version 2 of the License, or
 *	(at your option) any later version. 
 * 
 *	This file is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.
 *
 *	You should have received a copy of the GNU General Public License
 *	along with this file; if not, write to the Free Software
 *	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef PT_CONDITION_H
#define PT_CONDITION_H
#include <portablethreads/config.h>
#ifdef WIN32
#	include <portablethreads/win32/condition.h>
#endif
#ifdef UNIX
#	include <portablethreads/unix/condition.h>
#endif

PT_NAMESPACE_BEGIN

class PNullCondition : public PWaitable
{
	PNullCondition(const PNullCondition& o);
	PNullCondition& operator=(const PNullCondition& o);
public:
	PNullCondition()
	{}
	
	void signal() {}
	void wait() {}
	bool wait(unsigned long sec, unsigned long nano = 0)
	{
		return false;
	}	
	bool queryState()
	{ 
		return false;
	}
};

template<>
class PSingleWait<PNullCondition>
{
	PSingleWait();
public:	
	PSingleWait(PNullCondition& waitfor)
	{}
	void wait() {}
};

template<>
class PSingleWait<PCondition>
{
	PCondition& waitFor_;
	PSingleWait();
public:	
	PSingleWait(PCondition& waitfor)
		:	waitFor_(waitfor)
	{}
	void wait()
	{
		waitFor_.wait();	
	}
};
PT_NAMESPACE_END

#endif
