/*  Copyright (c) January 2005 Jean Gressmann (jsg@rz.uni-potsdam.de)
 *
 *  This is free software; you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License as published by
 *	the Free Software Foundation; either version 2 of the License, or
 *	(at your option) any later version. 
 * 
 *	This file is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.
 *
 *	You should have received a copy of the GNU General Public License
 *	along with this file; if not, write to the Free Software
 *	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef PT_CONFIG_H
#define PT_CONFIG_H

// Check for necessary defines
#if !defined(WIN32) && !defined(UNIX)
#	error "You need to define either WIN32 or UNIX!"
#endif

#ifndef PT_GLOBAL_NAMESPACE
#	define PT_NAMESPACE PortableThreads
#	define PT_NAMESPACE_BEGIN namespace PT_NAMESPACE {
#	define PT_NAMESPACE_END };
#else
#	define PT_NAMESPACE 
#	define PT_NAMESPACE_BEGIN
#	define PT_NAMESPACE_END
#endif

// architecture specific code
#if defined(WIN32)
#	if defined(_MSC_VER)
#		define PT_ALIGN(N, X) __declspec(align(N)) X
#		include <portablethreads/arch/x86-32-win32-msvc.h>
#	endif
#	if defined(__MINGW32__)
#		define PT_ALIGN(N, X) X __attribute__((__aligned__(N)))
#		include <portablethreads/arch/x86-32-win32-mingw.h>
#	endif
#endif
#ifdef UNIX
#	if defined(__GNUC__)
#		define PT_ALIGN(N, X) X __attribute__((__aligned__(N)))
#		if defined(__i386__) || defined(__i486__) || defined(__i586__) || defined(__i686__)
#			include <portablethreads/arch/x86-32-linux-gcc.h>
#		else // assume x86 64 bit
#			include <portablethreads/arch/x86-64-linux-gcc.h>
#		endif
#	endif
#endif

#include <portablethreads/common/utility.h>
#include <portablethreads/common/thread_base.h>

// platform specific code
#ifdef WIN32
#	include <portablethreads/win32/config.h>
#endif
#ifdef UNIX
#	include <portablethreads/unix/config.h>
#endif


#endif
