/*  Copyright (c) January 2005 Jean Gressmann (jsg@rz.uni-potsdam.de)
 *
 *  This is free software; you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License as published by
 *	the Free Software Foundation; either version 2 of the License, or
 *	(at your option) any later version. 
 * 
 *	This file is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.
 *
 *	You should have received a copy of the GNU General Public License
 *	along with this file; if not, write to the Free Software
 *	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef PT_MONITOR_H
#define PT_MONITOR_H
#include <portablethreads/config.h>
#include <portablethreads/condition.h>
#include <portablethreads/atomic_number.h>

PT_NAMESPACE_BEGIN

//
class PMonitor
{
public:
	PMonitor()
		:	guard_(0) // default construction of PCondition must ensure it is NOT signaled
		,	interested_(0)
	{}
	inline void enter()
	{
		++interested_;
		// if this is the first thread the while loop is not entered...
		while(!pt_atomic_cas(&guard_, 1, 0))
		{
			// ... wait till monitor is free
			monitorEmpty_.wait();
		}
	}
	inline void leave()
	{
		assert(guard_ == 1);
		pt_atomic_cas(&guard_, 0, 1);
		// if upon leaving we find other threads interested in
		// the monitor we wake one up.
		if(--interested_ > 0)
			monitorEmpty_.signal();
	}
private:
	PMonitor(const PMonitor&);
	PMonitor& operator=(const PMonitor&);	
private:
	volatile pt_int_type guard_;
	PAtomicNumber interested_;
	PCondition monitorEmpty_;
};

template<> 
class PMutexHelper<PMonitor>
{
	PMonitor& monitor_;
public:
 	PMutexHelper(PMonitor& monitor) 
		:	monitor_(monitor)
	{
		monitor_.enter();
	}
	
	~PMutexHelper()
	{
		monitor_.leave();
	}
};

PT_NAMESPACE_END

#endif
